package cn.smarthse.modules.health.service.work.assign;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.assign.RiskAssign;
import cn.smarthse.modules.health.entity.work.assign.param.RiskAssignSearch;
import cn.smarthse.modules.health.entity.work.assign.push.ChuangdePushRiskData;
import cn.smarthse.modules.health.entity.work.assign.vo.RiskAssignVO;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

/**
 * @ClassName IRiskAssignService
 * @Description 交办/通报风险接口
 * @Author 曾华川
 * @Date 2024年03月07日 19:10
 **/
public interface IRiskAssignService extends IBaseService<RiskAssign> {

    /**
     * 获取首页工作卡片列表
     * @return
     */
    PageInfo<RiskAssignVO> getPageList(JqGridParam param, RiskAssignSearch search);

    /**
     * 获取风险详情列表
     * @param param
     * @param search
     * @return
     */
    PageInfo<RiskAssignVO> getRiskCompanyList(JqGridParam param, RiskAssignSearch search);

    /**
     * 获取待推送列表
     * @param search
     * @return
     */
    List<RiskAssignVO> getPendingList(RiskAssignSearch search);

    /**
     * 获取工作卡片简略信息
     * @param workId
     * @return
     */
    RiskAssignVO getInfoByWorkId(Long workId);

    /**
     * 风险推送计数
     * @param workId
     * @param areaLevel
     * @param areaId
     * @return
     */
    RiskAssignVO getPushCount(Long workId, Byte areaLevel, Long areaId);

    /**
     * （批量）存草稿
     * @param search
     * @param loginUserId
     * @return
     */
    Long saveWork(RiskAssignSearch search, Long loginUserId);

    void batchInsert(List<RiskAssign> riskList, Long workId, Long loginUserId);

    /**
     * @param search
     * @Title: removePendingList
     * @Description: 移除待推送清单
     * @author 曾华川
     * @date 2024-03-20 14:12:16
     */
    void removePendingList(RiskAssignSearch search);

    /**
     * 删除工作卡片
     * @param workId
     * @return
     */
    Long deleteWork(Long workId);

    /**
     * 保存风险信息
     *
     * @param risk
     * @param isPush      是否推送，true-保存并推送，false-仅保存
     * @param loginUserId
     * @return
     */
    List<ChuangdePushRiskData> saveWorkRisk(RiskAssign risk, Boolean isPush, Long loginUserId);

    /**
     * 保存、推送交办风险
     *
     * @param riskAssignList 风险数据集合
     * @param loginUserId
     * @return
     */
    List<ChuangdePushRiskData> pushRiskInfo(List<RiskAssign> riskAssignList, Long loginUserId);

    /**
     * 导入交办风险
     *
     * @param fileUrl
     * @param workId
     * @param loginUserId
     * @throws Exception
     */
    Map<Integer, Object> importListData(String fileUrl, Long workId, Long loginUserId) throws Exception;

    /**
     * 根据推送风险反馈结果，同步系统中的风险数据
     */
    void syncRiskList();

    /**
     * 获取推送风险的反馈结果
     * @param pushedData
     * @return
     */
    List<RiskAssign> getPushResult(List<ChuangdePushRiskData> pushedData);

}
