package cn.smarthse.modules.health.service.weChat;

import cn.smarthse.modules.health.entity.base.device.DeviceMaintenanceWorkItemVo;
import cn.smarthse.modules.health.entity.base.wmbase.WmMaintenanceDetailWorkItemVo;
import cn.smarthse.modules.health.vo.shield.ShieldTipVO;
import cn.smarthse.modules.health.vo.work.accident.AccidentTipVO;
import cn.smarthse.modules.health.vo.work.certificate.CertificateWorkItemVo;
import cn.smarthse.modules.health.vo.work.check.CheckTipVO;
import cn.smarthse.modules.health.vo.work.eme.EmeTipVO;
import cn.smarthse.modules.health.vo.work.evaluate.EvaluateItemVO;
import cn.smarthse.modules.health.vo.work.harmFactorDeclare.HarmFactorDecWorkItemVo;
import cn.smarthse.modules.health.vo.work.harmFactorTest.HcCheckPlanFirstPageVo;
import cn.smarthse.modules.health.vo.work.harmfactor.HarmfactorItemVO;
import cn.smarthse.modules.health.vo.work.informManager.InformManagerFirstPageVo;
import cn.smarthse.modules.health.vo.work.reform.ReformItemTodolistVO;
import cn.smarthse.modules.health.vo.work.sceneInspection.SceneInspectionTodolistVO;
import cn.smarthse.modules.health.vo.work.thirdtime.PdMonitorWorkItemVO;
import cn.smarthse.modules.health.vo.work.thirdtime.ThirdtimeWorkItemVO;
import cn.smarthse.modules.health.vo.work.train.TrainWorkItemVo;
import cn.smarthse.modules.health.vo.work.yearplan.PlanYearWorkItemVO;

public interface IWorkItemService {
	/**
	 * 
	 * 
	 * @Comments:  <根据企业ID查询 职业病危害因素检测 关键工作项内容>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:21:36
	 * @param cid
	 * @return
	 */
	HcCheckPlanFirstPageVo getHcCheckPlanFirstPage(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <通过职业健康体检读取数据 >
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:21:53
	 * @param cid
	 * @return
	 */
	CheckTipVO getCheckTips(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <通过教育培训Service读取数据>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:22:14
	 * @param cid
	 * @return
	 */
	TrainWorkItemVo getTrainToDoVoInfo(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <根据告知管理Service读取数据 >
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:22:31
	 * @param cid
	 * @return
	 */
	InformManagerFirstPageVo getInformManagerFirstPageVoData(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <读取人员证书管理关键工作数据 >
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:22:43
	 * @param cid
	 * @return
	 */
	CertificateWorkItemVo getCertTodoInfo(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <读取 职业病危害项目申报 关键数据接口>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:22:54
	 * @param cid
	 * @return
	 */
	HarmFactorDecWorkItemVo getDeclareTodoIndo(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <根据职业卫生现场检查Service读取关键工作数据>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:23:06
	 * @param cid
	 * @return
	 */
	SceneInspectionTodolistVO getSceneInspectionTodolistVo(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <根据整改管理Service读取关键工作数据>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:23:19
	 * @param cid
	 * @return
	 */
	ReformItemTodolistVO getReformItemTodoListVo(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <根据“三同时“管理 Service读取关键工作数据>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:23:31
	 * @param cid
	 * @return
	 */
	ThirdtimeWorkItemVO getThirdtimeVo(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <根据个人防护用品管理Service读取关键工作数据 接口>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:23:45
	 * @param cid
	 * @return
	 */
	ShieldTipVO getShieldTipVO(Long cid);

	/**
	 * 
	 * 
	 * @Comments:  <警示标识维护service 读取数据关键工作项>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:23:56
	 * @param cid
	 * @return
	 */
	WmMaintenanceDetailWorkItemVo getWmMaintenanceDetailWorkItemVo(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <根据应急管理Service读取关键工作数据>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:24:08
	 * @param cid
	 * @return
	 */
	EmeTipVO getEmeTipVO(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <根据事故管理Service读取关键工作数据>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:24:22
	 * @param cid
	 * @return
	 */
	AccidentTipVO getAccidentTipVO(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <年度计划>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年6月20日-上午11:24:38
	 * @param cid
	 * @return  loginStaffId 职业卫生的人员id
	 */
	PlanYearWorkItemVO getPlanYearWorkItem(Long cid,Long loginStaffId);

	DeviceMaintenanceWorkItemVo DeviceMaintenanceWorkItem(Long cid);

	EvaluateItemVO EvaluateWorkItem(Long cid);

	HarmfactorItemVO harmfactorWorkItem(Long cid);
	
	PdMonitorWorkItemVO getPdMonitorWorkItemVO(Long cid);
	
}
