/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.sys.message;

import java.util.List;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.sys.message.SysMessage;
import cn.smarthse.modules.health.vo.MessageTotalInfo;


 /**
 * 
 * 《SysMessageService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017-06-13 01:30
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ISysMessageService extends IBaseService<SysMessage>{

	
	/**
	 * 
	 * 
	 * @Comments:  根据员工ID，获取未读消息的信息
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年7月6日-下午5:03:05
	 * @param staffId 员工ID
	 * @return
	 */
	List <MessageTotalInfo> getUnReadMessageInfoByStaffId(Long staffId);
	
	/**
	 * 
	 * 
	 * @Comments:  添加消息
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年7月7日-下午1:06:36
	 * @param message 消息内容。（必填内容：除了ID，创建人、创建时间、更新者、更新时间都必须填）
	 * @param receiverList 消息接收人列表（如果为-1，则全公司员工）
	 * @param loginStaffId 当前系统登录的员工ID，（也是发送消息的员工ID）
	 * @param cid 当前系统登录员工的企业ID
	 */
	void pushMessage(SysMessage message,List<Long> receiverList,Long loginStaffId,Long cid);

}
