package cn.smarthse.modules.health.service.sys.message;

import cn.smarthse.modules.health.entity.sys.message.MessageUser;
import cn.smarthse.modules.health.entity.sys.message.vo.MessageCount;
import cn.smarthse.modules.health.entity.sys.message.vo.MessageParam;

import java.util.List;

public interface IMessageUserService {

    MessageUser read(MessageUser messageUser);

    MessageUser ignore(MessageUser messageUser);

    MessageUser delay(MessageUser messageUser);

    void addDeleteMessage(MessageUser messageUser);

    /**
     * 改变消息状态
     */
    Boolean changeMessageState(List<Long> ids, MessageUser messageUser, Long loginStaffId);

    Boolean addMessageUser(MessageUser messageUser);

    /**
     * 获取某个用户其已经收到的最新消息时间，可按类型区分
     */
    String getLatestMessageByUserId(Long loginStaffId, Integer bussinesFromType);

    /**
     * 是否已存在该用户的消息，且不是第一次访问所存留的，可按类型区分
     */
    Boolean isExistByUserId(Long loginStaffId, Integer bussinesFromType);

    /**
     * 未读消息总量，可按类型区分
     */
    List<MessageCount> getNoReadCountBy(MessageParam param);
}
