package cn.smarthse.modules.health.service.sys.message;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.sys.message.vo.MessageCount;
import cn.smarthse.modules.health.entity.sys.message.vo.MessageParam;
import com.github.pagehelper.PageInfo;

import java.util.List;

public interface IMessageService {

    PageInfo<Message> getPage(JqGridParam gparam, MessageParam param);

    List<MessageCount> getUnreadMessageCount(MessageParam param);

    /**
     * @param message.businessId       业务id
     * @param message.businessName     业务名称（必填）
     *                                 名称根据任务有所不同：
     *                                 1）提醒：根据具体情况描述；
     *                                 2）工作消息：工作名称+动作，动作包括：请审批；已审批；请反馈；有反馈；请查看；请开展工作；证书到期；
     *                                 3）通知公告：通知公告的名称；
     *                                 4）系统消息：系统版本更新；
     *                                 5）法律法规消息：法律法规名称+动作，动作包括：发布；作废；废止
     * @param message.businessNo       业务编号
     * @param message.bussinesType     业务类型（必填）： MessageBusinessTypeEnum.value
     * @param message.businessContent  业务详情（通知公告详情）
     * @param message.bussinesFromType 业务来源类型（必填）  MessageBusinessFromEnum.value
     * @param message.bussinesFrom     业务来源 （必填） MessageBusinessFromEnum.name或自定义
     * @param message.processUrl       业务查看链接：法律法规外部链接
     * @param message.sendTime         发送时间（必填）
     * @param message.createUser       创建人名称
     * @param createBy                 创建人id（必填）
     * @param cid                      职业卫生企业id
     * @param message.receivers        接收人（隐患排查：创建人；法律法规：如果是系统对用户反馈的通知就发送给反馈人；其他暂不传此参数）
     * @Comments: <首页提醒消息推送（评价工作管理、隐患排查、监管集团版通知公告、监管通知公告、法律法规消息、系统消息）>
     * @author yanao [ya@smarthse.cn]
     * @since 2018年7月26日-下午3:27:19
     */
    Message pushMessage(Message message, Long createBy, Long cid);

    /**
     * @param msgType     MessageBusinessTypeEnum.value
     * @param name        消息名称
     * @param content     消息内容
     * @param bussinessId 业务id
     * @param cid
     * @return void
     * @Comments: <给管理员发送消息>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2022/2/9-13:47
     */
    void pushManagerMessage(Message message, Long cid);

    Message multiPushMessage(Message message, Long createBy, Long cid);

    void deleteById(Long id, Long loginStaffId);

    Message getById(Long id);

    void sendMessage2Admin(String messageContent, Long createBy);

    void addTrainingVideoMessage(Message message, Long cid, Long createBy);

    /**
     * 企业用户 获取其所有指定类型消息
     * 目前适用于职业健康在线培训
     *
     * @param type             1：全部 2：未读
     * @param cid
     * @param loginStaffId
     * @param param
     * @param areaId
     * @param bussinesFromType 消息类型
     * @param belongType       发送直属企业类型(0-非直属；1-省直属；2-市属；3-所有）
     * @return
     */
    PageInfo<Message> getTrainingMessageListData(Byte type, Long cid, Long loginStaffId, JqGridParam param, Long areaId, Integer bussinesFromType, Integer belongType);

    Message addMessage(Message message);

    /**
     * 获取指定区域内系统中的某种消息的最新时间
     */
    String getLatestMessage(List<Long> areaList, Integer bussinesFromType);
}