package cn.smarthse.modules.health.service.sys.dic;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.sys.dic.DicType;
import cn.smarthse.modules.health.entity.sys.dic.DicValue;
import cn.smarthse.modules.health.vo.sys.dic.DicValueVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc
 * @since 2020/3/3 0003 15:40
 */
public interface IDicValueService extends IBaseService<DicValue> {


    /**
     * 查询
     * @param dicId 字典id
     * @param valueLabel 标签
     * @param status 状态 1：正常 2：停用
     * @param page
     * @param rows
     * @return
     */
    PageInfo<DicValueVo> query(Long dicId, String valueLabel, Integer status, int page, int rows);

    /**
     * 删除
     * @param idList
     * @param loginStaffId
     */
    void deleteMulit(List<Long> idList, Long loginStaffId);


    public List<DicValueVo> queryDicValueByTypeCode(String typeCode);
}
