package cn.smarthse.modules.health.service.sys.dic;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.sys.dic.DicType;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc
 * @since 2020/3/3 0003 15:40
 */
public interface IDicTypeService extends IBaseService<DicType> {

    /**
     * 查询
     * @param nameOrTypeCode 名称或类型 (可以null)
     * @param status 状态 1：正常 2：停用 (可null)
     * @param createStartDate 创建日期（开始时间 可以null）
     * @param createEndDate 创建日期（结束时间 可以null）
     * @param pageNum 页码
     * @param pageSize 每页大小
     * @return
     */
    PageInfo<DicType> query(String nameOrTypeCode, Integer status,
                            Date createStartDate, Date createEndDate,
                            int pageNum, int pageSize);

    /**
     * 删除
     * @param idList
     * @param loginStaffId
     */
    void deleteMulit(List<Long> idList, Long loginStaffId);
}
