package cn.smarthse.modules.health.service.sys;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.sys.SysUserTip;
import cn.smarthse.modules.health.entity.sys.vo.UserDataScope;
import cn.smarthse.modules.health.entity.sys.vo.UserFormSuperviseInfo;
import cn.smarthse.modules.health.entity.sys.vo.UserFormVO;
import cn.smarthse.modules.platform.model.UserModel;
import com.github.pagehelper.PageInfo;

import javax.smarthse.exception.ServiceException;
import java.util.List;

/**
 * 《系统用户Service接口定义》
 *
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @Project: GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @since 2017-05-25 09:36
 */
public interface ISysUserService extends IBaseService<SysUser> {

    /**
     * 根据用户名，获取用户实体
     *
     * @param username 用户名
     * @return SysUser
     */
    SysUser getUserByuserame(String username);

    SysUser getAvailableUserByuserame(String username);

    /**
     * 读取企业有效的用户列表
     *
     * @param gparam 查询条件
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-6-6-下午3:23:11
     */
    PageInfo<SysUser> getUserListByGridParam(JqGridParam gparam);

    /**
     * 删除用户
     * <li>1、将用户主表设置为无效
     * <li>2、物理删除用户角色表
     * <li>3、
     *
     * @param viewUser
     * @param loginStaffId
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-6-29-上午10:46:03
     */
    void deleteUser(SysUser viewUser, Long loginStaffId);

    /**
     * 通过表单添加用户
     *
     * @param userForm
     * @param updateBy
     * @param cid
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-6-30-下午4:08:18
     */
    void addForm(UserFormVO userForm, Long updateBy, Long cid) throws ServiceException;

    /**
     * 通过表单修改用户
     * <li>用户名不可修改
     *
     * @param userForm
     * @param updateBy
     * @param cid
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-6-30-下午4:08:18
     */
    void editForm(UserFormVO userForm, Long updateBy, Long cid) throws ServiceException;

    /**
     * 更新用户,并处理用户与员工关系
     *
     * @param userId    用户ID
     * @param cid       企业编号
     * @param staffForm 员工基础信息
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-8-17-下午4:32:51
     */
    SysUser updateUserFromStaffInfoForm(Long userId, Long cid, StaffInfo staffForm);

    /**
     * 清除与该StaffId相关的用户
     *
     * @param staffId
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-7-3-上午9:40:59
     */
    void clearUserStaff(Long staffId, Long updateBy);

    /**
     * 添加企业软件用户(包含管理员userinfo.isManger)
     *
     * @param cid      企业编号
     * @param staffId  企业员工编号
     * @param userinfo
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-7-19-下午3:01:06
     */
    SysUser addManger(Long cid, Long staffId, UserModel userinfo);

    /**
     * 清除企业所有管理员，原管理员用户无效
     * <li>可能有想法想将账号直接删除
     *
     * @param cid
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-7-19-下午4:44:43
     */
    void clearUserManger(Long cid);

    /**
     * @param cid
     * @Comments: <移除企业所有管理员角色，原管理员用户仍然有效>
     * @author yanao [ya@smarthse.cn]
     * @since 2017年12月18日-下午3:46:10
     */
    void removeUserManagerRole(Long cid);

    /**
     * 根据员工ID读取关联的用户
     *
     * @param staffId
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-8-17-下午3:32:16
     */
    List<SysUser> getUserListByStaff(Long staffId);

    Integer getCountByCid(Long cid);

    /**
     * @param cid
     * @param staffId
     * @Comments: <移除企业已关联的员工>
     * @author yanao [ya@smarthse.cn]
     * @since 2017年12月18日-下午11:29:07
     */
    void removeStaff(Long cid, Long staffId);

    /**
     * <获取管理员用户> 排除 -hse用户
     *
     * @param cid
     * @return
     * @author yanao [ya@smarthse.cn]
     * @since 2018年1月10日-下午4:20:08
     */
    List<SysUser> getUserManager(Long cid);

    List<UserDataScope> getAllDataScopeInfo(Long staffId);

    String checkStaff(Long cid, Long staffId);

    SysUser getStaffUser(Long cid, Long staffId, Long userId);

    /**
     * 监管端添加用户信息
     *
     * @param userinfo
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi（肖奕)
     * @since 2020年4月11日-上午10:03:08
     */
    Long addUserFromSupervise(UserFormSuperviseInfo userinfo);

    void editCustomUser(UserFormVO userForm, Long updateBy, Long cid) throws ServiceException;

    void addCustomUser(UserFormVO userForm, Long updateBy, Long cid) throws ServiceException;

    /**
     * 禁用或启用账号
     *
     * @Author: XiaoYi(肖奕)
     * @Date: 2020/11/20 11:22
     * @param: [cid, flag]flag=1启用，flag=0禁用
     * @return: java.lang.Integer
     **/
    Integer disableOrEnableUserByCid(Long cid, Integer flag, Long loginUserId);

    Integer disableOrEnableUserByCids(String cids, Integer flag, Long loginUserId);

    Integer disableOrEnableUserByCidList(List<Long> cidList, Integer flag, Long loginUserId);

    /**
     * 删除或恢复
     *
     * @Author: XiaoYi(肖奕)
     * @Date: 2020/11/20 11:22
     * @param: [cid, flag]flag=1恢复，flag=0删除
     * @return: java.lang.Integer
     **/
    Integer deleteOrRecoverUserByCid(Long cid, Integer flag);

    public int resetPassword(String username, String plainPassword);

    public int updateLastLoginTime(Long userId);

    Integer resetPasswordByUserId(Long userId, String plainPassword, Long loginUserId);

    Integer resetPasswordByUserId(List<Long> userIds, String plainPassword);

    /**
     * 判断手机号是否已被绑定
     *
     * @Author: XiaoYi(肖奕)
     * @Date: 2020/11/27 14:04
     * @param: [phone]
     * @return: java.lang.Boolean
     **/
    Boolean isBindedPhone(String phone);

    public SysUser getSysUserByMobile(String mobile);

    /**
     * 数据权限缓存清理
     *
     * @param
     * @return void
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2020/12/18-14:34
     */
    public void clearDataScope();

    List<SysUser> listAllAdmin();

    public SysUserTip getControlNotifByUserId(Long userId);

    /**
     * @param userId
     * @param controlNotif
     * @return void
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2021/5/8-14:34
     */
    public void saveControlNotif(Long userId, Integer controlNotif);

    SysUser getUserByuserameAndCid(String username, Long cid);

    Integer deleteUserByCid(List<Long> cidList, Long loginUserId);

    /**
     * 三个月没修改过密码的用户修改用户状态为初始密码
     *
     * @ Author XiaoYi
     * @ Date  2022/10/9  10:04
     * @ param
     * @ return
     **/
    public void updatePassStateThreeMonth();

    /**
     * 判断用户名称是否已存在
     */
    Boolean isHaveThisName(String name, Long excludeId);

    /**
     * 判断用户名称是否已存在
     */
    Boolean isHaveThisName(List<String> nameList);

    /**
     * 导入回滚
     */
    void rollbackImportUserData(List<Long> idList);

    List<SysUser> getUserInfoByCidList(List<Long> cidList);

    /**
     * 所有密码为默认密码，但是is_default_pwd字段为false的账号
     */
    List<SysUser> isDefaultPwdList();

}
