/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.sys;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.sys.SysUserLayout;
import cn.smarthse.modules.health.enums.sys.UserLayoutGroupEnum;


 /**
 * 
 * 《用户自定义布局Service》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-08-16 01:18
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface ISysUserLayoutService extends IBaseService<SysUserLayout>{
	
	/**
	 * 读取用户所有布局信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-8-16-下午1:26:25
	 * @param staffId		员工ID
	 * @return
	 */
	List<SysUserLayout> getUserLayoutList(Long staffId);
	
	
	/**
	 * 更新基础信息布局
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-8-21-上午11:25:22
	 * @param indexlayoutCodes
	 * @param worklayoutCodes
	 */
	void saveUserBaseLayout(Long cid,  Long staffId, String layoutCodes );
	
	/**
	 * 更新首页布局
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-8-21-上午11:25:22
	 * @param indexlayoutCodes
	 * @param worklayoutCodes
	 */
	void saveUserIndexLayout(Long cid,  Long staffId, String indexlayoutCodes , String worklayoutCodes);
	
	/**
	 * 读取用户布局信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-8-16-下午1:52:43
	 * @param staffId					员工ID
	 * @param layoutGroup		布局信息
	 * @return
	 */
	SysUserLayout getUserLayout(Long staffId,String layoutGroup );
	
	/**
	 * 清除用户分级布局
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-8-16-下午1:28:59
	 * @param staffId				员工ID
	 * @param layoutGroup	base,基础信息,work关键工作,index首页
	 */
	void clearUserLayout(Long staffId, String layoutGroup);

}
