/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.sys;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.entity.sys.SysUserInvite;
import com.github.pagehelper.PageInfo;
import org.springframework.transaction.annotation.Transactional;

import javax.smarthse.exception.ServiceException;


 /**
 * 
 * 《用户邀请表Service》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-06-30 02:22
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface ISysUserInviteService extends IBaseService<SysUserInvite>{

	/**
	 * 邀请用户
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-6-30-下午2:31:22
	 * @param user				已存在的用户实体
	 * @param inviteStaffId	邀请加入后绑定的员工ID
	 * @param cid					企业编号
	 * @param loginStaffId		当前登录用户(员工编号)
	 */
	void initUsername(SysUser user, Long inviteStaffId, Long cid, Long loginStaffId) throws ServiceException;

	/**
	 * 重新发起邀请
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-6-30-下午2:51:45
	 * @param id
	 * @param cid
	 * @param loginStaffId
	 */
	void initAgain(Long id, Long cid, Long loginStaffId);

	/**
	 * 根据Grid参数查询企业邀请列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-7-3-下午2:50:16
	 * @param param
	 * @return
	 */
	PageInfo<SysUserInvite> getListByGridParam(JqGridParam param);



}
