/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.sys;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.sys.SysParam;
import cn.smarthse.modules.health.enums.sysParam.SysParamGroupEnum;


 /**
 * 
 * 《系统参数Service接口定义》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-06-06 10:12
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface ISysParamService extends IBaseService<SysParam>{


	/**
	 * 根据分组查询系统参数
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-6-28-下午2:37:34
	 * @param group [SysParamGroupEnum 系统参数分组枚举]
	 * @return
	 */
	List<SysParam> getListByGroup(SysParamGroupEnum group);
	
	/**
	 * 
	 * 
	 * @Comments:  <根据param_group 获取参数列表（这样主要是考虑到param_group 直接通过前台传过来，这样比较灵活）>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年7月10日-下午2:02:06
	 * @param group
	 * @return
	 */
	List<SysParam> getListByGroup(String group);
	
	/**
	 * 
	 * 
	 * @Comments:  根据参数名，获取系统参数信息
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月4日-下午5:07:36
	 * @param paramName 参数名
	 * @param cid 企业ID
	 * @param group 分组枚举
	 * @return
	 */
	SysParam getSysParamByName(String paramName,Long cid,SysParamGroupEnum group);
	
	/**
	 * 根据code，value，grop，name，获取系统参数信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月25日-下午5:41:02
	 * @param paramName
	 * @param cid
	 * @param group
	 * @param paramCode
	 * @return
	 */
	SysParam getSysParamByNameGroupCode(String paramName,Long cid,SysParamGroupEnum group,String paramCode);
}
