/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.sys;

import java.util.Date;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.sys.SysCoreWorkModuleCorrelation;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.TodlistInfoTypeEnum;


 /**
 * 
 * 《SysCoreWorkModuleCorrelationService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017-08-25 09:50
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface ISysCoreWorkModuleCorrelationService extends IBaseService<SysCoreWorkModuleCorrelation>{

	
	/**
	 * 整改（来源是危害因素检测）完成的时候调用此方法
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午11:35:32
	 * @param businessId
	 */
	void reformComplete(Long businessId,Long loginStaffId,Long cid);
	
	/**
	 * 岗位危害因素变更时调用
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午11:39:30
	 * @param workId 岗位ID
	 */
	void postHarmFactorChange(Long workId,Long loginStaffId,Long cid);
	
	/**
	 * 增加危害因素管理工作提示信息
	 * 调用时机：
	 * 1、职业病危害因素检测结果录入完成时
	 * 2、有新增工种时
	 * 3、设备/原辅物料有变更时
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年2月28日-上午10:23:42
	 * @param sourceCoreWork 来源模块（区域、工种、职业病危害因素检测）
	 * @param businessId 业务ID
	 * @param businessName 业务名称（xxx区域、xxx工种、xxx项目)
	 * @param cid
	 */
	void addHarmFactorManagerTodolistInfo(CoreWorkEnum sourceCoreWork,Long businessId,String businessName,Long loginStaffId,Long cid);
	
	/**
	 * 区域危害因素变更时调用
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-下午12:55:23
	 * @param areaId 区域ID
	 */
	void areaHarmFactorChange(Long areaId,Long loginStaffId,Long cid);

	/**
	 * 
	 * 
	 * @Comments:  <三同时项目，进入可研阶段的时候调用此方法>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年12月20日-上午11:06:49
	 * @param businessId
	 * @param businessName
	 * @param loginStaffId
	 * @param cid
	 */
	public void threeSimultaneityProjectStudy(Long businessId, String businessName,Long loginStaffId,Long cid) ;

	/**
	 * @Comments:  <评价 工作完成时  调用>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2019/7/17-14:34
	 * @param evaluateId
	 * @param workName
	 * @param evaluteType
	 * @param loginStaffId
	 * @param cid
	 * @return void
	*/
	public void finishEvaluate(Long evaluateId, String workName, Byte evaluteType, Long loginStaffId, Long cid);
	/**
	 * 三同时项目，试运行阶段的时候调用此方法
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午10:06:11
	 * @param businessId 项目ID
	 * @param businessName 项目名称
	 */
	void threeSimultaneityProjectRun(Long businessId,String businessName,Long loginStaffId,Long cid);
	
	/**
	 * 三同时项目完成（非完成阶段）的时候调用此方法
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午10:58:46
	 * @param businessId 业务ID
	 * @param businessName 业务名称
	 */
	void threeSimultaneityComplete(Long businessId,String businessName,Long loginStaffId,Long cid);
	
	/**
	 * 来源模块（三同时）删除业务信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年12月27日-上午11:44:06
	 * @param businessId 业务ID
	 */
	void soureBusinessDelete(Long businessId,Long loginStaffId);
	
	/**
	 * 事故上报完成调用此方法
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午10:07:31
	 * @param businessId 事故上报业务ID
	 */
	void accidentReportComplete(Long businessId,Long loginStaffId,Long cid);
	
	/**
	 * 删除/终止业务(来源是三同时、事故上报、整改等的时候）的时候调用此方法
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午10:08:42
	 * @param coreWork 业务模块枚举
	 * @param businessId 业务模块业务ID
	 */
	void businessDelete(CoreWorkEnum coreWork,Long businessId,Long loginStaffId,Long cid);
	
	
	/**
	 * 开始业务(来源是三同时、事故上报、整改等的时候）的调用此方法
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午10:32:54
	 * @param coreWork 业务模块
	 * @param sourceCoreWork 来源模块（三同时、整改、事故）等
	 * @param sourceBusinessIds 源业务ID（三同时、整改业务ID)
	 * @param desBusinessId 本模块业务ID
	 */
	void businessStart(CoreWorkEnum coreWork,CoreWorkEnum sourceCoreWork,Long desBusinessId,Long loginStaffId,Long cid,Long...sourceBusinessIds);
	
	/**
	 * 业务完成(来源是三同时、事故上报、整改等的时候）调用此方法
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午10:43:41
	 * @param coreWork 业务模块
	 * @param sourceBusinessId 源业务ID（三同时、整改业务ID)，源模块是事故上报的时候，此参数为空
	 * @param desBusinessId 目标业务ID
	 */
	void businessComplete(CoreWorkEnum coreWork,CoreWorkEnum sourceCoreWork,Long desBusinessId,Long loginStaffId,Long cid,Long... sourceBusinessId);
	
	/**
	 * 获取需要提醒的关键工作列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月25日-上午10:50:27
	 * @param sourceCoreWork 来源模块（三同时、整改、事故上报）
	 * @param desCoreWork 目标模块（这个方法谁调用，就传哪个模块）
	 * @return
	 */
	List<SysCoreWorkModuleCorrelation> getListToRemind(CoreWorkEnum sourceCoreWork,CoreWorkEnum desCoreWork,Long cid);
	
	/**
	 * 忽略
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月28日-上午11:45:44
	 * @param sourceCoreWork 源模块
	 * @param desCoreWork 目标模块
	 * @param sourceBusinessId 源业务ID（如果源模块为三同时，则不能为空，如果源模块是事故，则为null）
	 * @param cid 企业ID
	 * @param loginStaffId 登录员工ID
	 */
	ResponseData<Boolean> ignore(TodlistInfoTypeEnum todolistType,CoreWorkEnum sourceCoreWork,CoreWorkEnum desCoreWork,Long sourceBusinessId,Long cid,Long loginStaffId, Byte sourceModule);
	
	/**
	 * 获取最后忽略时间
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月30日-下午4:13:17
	 * @param todolistType 待办事项类型（周期提醒及提醒一次的待办事项提醒），见方法：TodlistInfoTypeEnum.isIgnoreNotBusiness
	 * @return 如果没有忽略过，则返回null
	 */
	Date getIgnoreLastDateTime(TodlistInfoTypeEnum todolistType,Long cid);
	
	/**
	 * 在指定的时间内，是否已经忽略过了。
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年12月20日-下午5:36:18
	 * @param type
	 * @param cid
	 * @param year
	 * @return
	 */
	boolean hasIgnoreData(TodlistInfoTypeEnum type ,Long cid, int year);
	
	/**
	 * 
	 * 
	 * @Comments:  <指定年份内是否已经忽略过了>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年12月21日-上午9:00:59
	 * @param type（忽略类型）
	 * @param cid（企业id）
	 * @param year（年份）
	 * @return
	 */
	boolean hasThisYearIgnoreData(TodlistInfoTypeEnum type ,Long cid, int year);
	
	/**
	 * 
	 * 
	 * @Comments:  <在指定的月份内，是否已经忽略过了>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年12月21日-上午9:31:48
	 * @param type
	 * @param cid
	 * @param month
	 * @return
	 */
	boolean hasMonthIgnoreData(TodlistInfoTypeEnum type ,Long cid, int month);

	 /**
	  * @param id
	  * @param projectName
	  * @param loginStaffId
	  * @param cid
	  * @Comments: <三同时进入归档，即可发出提示。  职业病危害申报>
	  * @author zhoulj(周利军) [1217102780@qq.com]
	  * @since 2017年8月30日-上午9:52:07
	  */
//	void threeSimultaneityProjectFinish(Long id, String projectName, Long loginStaffId, Long cid);

	 /**
	  * @Comments:  <机构端上传评价信息 企业端关键工作的提示>
	  * @author zhoulj(周利军) [1217102780@qq.com]
	  * @since 2019/9/3-11:05
	  * @param businessId
	  * @param businessName
	  * @param loginStaffId
	  * @param cid
	  * @return void
	 */
	 public void uploadedEvaluateByOrgan(Long businessId, String businessName, Long loginStaffId, Long cid);
	 
	 
	 /**
	 * 
	 * @Comments:  <来自第三方检测上报（其实自己来源于自己）>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年9月24日-上午9:58:15
	 * @param sourceCoreWork
	 * @param businessId
	 * @param businessName
	 * @param loginStaffId
	 * @param cid
	 */
	void   appearHcCheckThirdPlan(CoreWorkEnum sourceCoreWork,Long businessId,String businessName,Long loginStaffId,Long cid);

	 /**
	  * 超过一年未检测
	  * @param sourceCoreWork
	  * @param businessId
	  * @param businessName
	  * @param loginStaffId
	  * @param cid
	  */
	void   addByNoCheckPlan(CoreWorkEnum sourceCoreWork,Long businessId,String businessName,Long loginStaffId,Long cid);

	 /**
	  * 第三方上传体检信息提醒
	  * @author yanao
	  * @since 2019年10月08日 11:00
	  * @param businessId
	  * @param businessName
	  * @param loginStaffId
	  * @param businessState(-1、被退回 1、初次上报 2、重新上报)
	  * @param cid
	  */
	 void uploadedCheckByOrgan(Long businessId, String businessName,Byte businessState, Long loginStaffId,Long cid);
	 /**
	  * 第三方上传职业病人诊断信息提醒
	  * @author yanao
	  * @since 2020年9月18日 11:00
	  * @param businessId
	  * @param diseaserName
	  * @param loginStaffId
	  * @param cid
	  */
	 void uploadedDiseaserByOrgan(Long businessId, String diseaserName, Long loginStaffId,Long cid);
	 
	 /**
	 * 
	 * @Comments:  <工作计划关键工作提醒（业务开始）>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月30日-上午11:47:16
	 * @param sourceCoreWork 每个业务模块
	 * @param sourceBusinessId       每个业务模块的Id
	 * @param loginStaffId  
	 * @param cid
	 * @param businessName    每个业务模块的工作名称
	 * @param desBusinessId  实施方案id
	 */
	void businessStartPlan(CoreWorkEnum sourceCoreWork,Long  sourceBusinessId ,
			 Long loginStaffId,Long cid,String businessName,Long desBusinessId);
	
	/**
	 * 
	 * @Comments:  <工作计划关键工作提醒（业务完成）>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月30日-下午1:08:40
	 * @param sourceCoreWork  每个业务模块
	 * @param sourceBusinessId  每个业务模块的Id
	 * @param loginStaffId
	 * @param cid
	 * @param businessName   每个业务模块的工作名称
	 */
	void businessCompletePlan(CoreWorkEnum sourceCoreWork,Long sourceBusinessId,
			 Long loginStaffId,Long cid,String businessName);

	/**
	 * 
	 * @Comments:  <工作计划关键工作提示>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年10月31日-上午9:40:07
	 * @param cid
	 * @param loginStaffId
	 * @return
	 */
	List<SysCoreWorkModuleCorrelation> getCompletedWorkListToRemind(Long cid, Long loginStaffId);

	/*
     * @Comments:  <机构端第三方培训上报时同步教育培训（教育培训来源自己）>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 10:13 2020/9/24
     **/
	 void appearOrgTrainPlan(CoreWorkEnum sourceCoreWork, Long businessId, String businessName,
									Long loginStaffId, Long cid);

}

