/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.sys;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.sys.SecUserRole;
import cn.smarthse.modules.health.entity.sys.vo.SecUserRoleVO;


 /**
 * 
 * 《用户角色Service接口定义》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-05-25 09:36
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
@Transactional
public interface ISecUserRoleService extends IBaseService<SecUserRole>{

	/**
	 *  根据用户ID查询用户角色列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-6-29-上午9:51:08
	 * @param userId		用户编号
	 * @return
	 */
	List<SecUserRole> getListByUserId(Long userId);

	/**
	 *  清除用户角色
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-6-29-上午10:52:59
	 * @param userId				用户编号
	 * @param updateBy		操作员工ID
	 * 		
	 */
	void deleteByUserId(Long userId, Long updateBy);

	/**
	 * 
	 * 
	 * @Comments:  <根据用户id获取用户的角色和权限信息>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年11月23日-下午4:40:27
	 * @param userId
	 * @return
	 */
	List<SecUserRoleVO> getUserRoleAndPermissionsByUserId(Long userId);
	
	/**
	 * 
	 * 
	 * @Comments:  <根据条件查询用户和角色关系>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年12月6日-下午2:39:34
	 * @param param
	 * @return
	 */
	List<SecUserRole> getListByUserId(SecUserRole param);
	
	/**
	 * 
	 * 
	 * @Comments:  <根据用户id绑定超级管理员角色>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年12月6日-上午10:35:37
	 * @param userId
	 * @param staffId
	 * @param cid
	 */
	void addSuperManagerRole(Long userId,Long staffId,Long cid);
	
	/**
	 * 
	 * 
	 * @Comments:  <移除企业所有管理员角色>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年12月18日-下午3:46:10
	 * @param cid
	 */
	void removeUserManagerRole(Long cid);
	
	/**
	 * 	
	 * 
	 * @Comments:  <增加一般用户角色>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年1月10日-下午4:57:22
	 * @param userId
	 * @param staffId
	 * @param cid
	 */
	void addNormalRole(Long userId,Long staffId,Long cid);

	/**
	 * 
	 * 
	 * @Comments:  <如果用户没有非管理员的角色，则增加一般用户角色>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年1月15日-下午3:33:09
	 * @param userId
	 * @param staffId
	 * @param cid
	 */
	void addNormalRoleIfHaveNotRole(Long userId, Long staffId, Long cid);

}
