/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.sys;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.sys.SecRole;
import cn.smarthse.modules.health.entity.sys.vo.SecPermissionParam;


 /**
 * 
 * 《角色Service接口定义》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-05-25 09:36
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
@Transactional
public interface ISecRoleService extends IBaseService<SecRole>{

	/**
	 * 查询角色列表（包含企业自定义）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-6-15-下午5:15:17
	 * @param gparam
	 * @return
	 */
	PageInfo<SecRole> getRoleList(JqGridParam gparam,List<Long>  roleIds);

	/**
	 *  读取企业角色列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-6-29-下午1:22:04
	 * @param cid
	 * @return
	 */
	List<SecRole> getListBycid(Long cid,List<Long>  roleIds);
	
	/**
	 * 
	 * 
	 * @Comments:  <根据cid/用户id获取角色列表>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年11月23日-上午10:52:21
	 * @param query
	 * @return
	 */
	List<SecRole> getListByQuery(SecPermissionParam query);

	/**
	 * 
	 * 
	 * @Comments:  <获取超级管理员角色>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年12月6日-上午9:39:14
	 * @return
	 */
	SecRole getSuperManager();
	
	/**
	 * 
	 * 
	 * @Comments:  <获取一般用户角色>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年1月10日-下午3:56:24
	 * @return
	 */
	SecRole getNormalRole();
	
	
	SecRole getByRoleName(String roleName);

}
