/**
 * 
 */
package cn.smarthse.modules.health.service.sys;

import java.util.List;
import java.util.Map;

import org.springframework.transaction.annotation.Transactional;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.sys.SecPermission;
import cn.smarthse.modules.health.entity.sys.vo.SecPermissionParam;
import cn.smarthse.modules.health.entity.sys.vo.SecPermissionVO;
import cn.smarthse.modules.health.entity.sys.vo.SecPermissionGroup;

/**
 * 《【系统管理】->【权限Service接口定义】》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-5-25-上午9:25:59
 */
@Transactional
public interface ISecPermissionService extends IBaseService<SecPermission> {

	
	/**
	 * 根据ID读取实体（包括parent数据属性）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-6-15-上午10:31:22
	 * @param id
	 * @return
	 */
	SecPermission getByIDWithEntity(Long id);
	
	/**
	 * 读取权限组名
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-6-14-下午2:36:14
	 * @return
	 */
	List<SecPermission> getSecPermissionGroupList(List<Long>  perIds);
	
	/**
	 * 根据父Ids查询列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-6-27-下午3:47:05
	 * @param parentIds
	 * @return
	 */
	List<SecPermission> getSecPermissionItemList(List<Long> parentIds);
	
	/**
	 * 读取权限列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2017-6-14-下午2:36:14
	 * @param gparam	搜索条件
	 * @return
	 */
	PageInfo<SecPermission> getSecPermissionList(JqGridParam gparam,SecPermissionParam query);
	
	/**
	 * 
	 * 
	 * @Comments:  <根据权限模块获取角色对应的所有权限详情>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年11月20日-上午11:40:46
	 * @param query
	 * @return
	 */
	Map<Long,SecPermissionGroup> getPermissionGroups(SecPermissionParam query);
	
	/**
	 * 
	 * 
	 * @Comments:  <根据角色id获取角色下的所有权限>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年11月22日-下午12:01:18
	 * @param query
	 * @return
	 */
	List<SecPermissionVO> getRolePermissionDetailList(SecPermissionParam query);
}
