package cn.smarthse.modules.health.service.sys;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.sys.ProjectFeedBack;
import cn.smarthse.modules.health.pojo.FeedBackSearchVo;
import cn.smarthse.modules.health.pojo.FeedBackVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 项目反馈接口
 *
 * @author Zhoucl
 * @date 2022/1/10 9:26
 * @desc
 */
public interface IProjectFeedBackService extends IBaseService<ProjectFeedBack> {

    /**
     * 根据项目id和类型查询反馈
     *
     * @param projectId
     * @param type
     * @return
     */
    ProjectFeedBack getFeedBackByIdAndType(Long projectId, Byte type);

    /**
     * 添加项目反馈
     *
     * @param data
     * @return
     */
    ProjectFeedBack addFeedBack(ProjectFeedBack data);

    /**
     * 删除项目反馈
     *
     * @param data
     */
    void deleteFeedBack(Long projectId, Byte type);

    /**
     * 根据类型查询所有有反馈的项目id
     *
     * @param type
     * @return
     */
    List<Long> queryHaveFeedBackResultCheckIds(Byte type);

    /**
     * @param companyName
     * @param status      是否处理（0-未处理 1-已处理  2-已忽略）
     * @param type        项目类型(1、体检 2、评价 3、培训 4、职业病人 5、检测)
     * @return
     */
    PageInfo<FeedBackVo> queryByCompanyAndType(JqGridParam gparam, FeedBackSearchVo searchVo);

    /**
     * 更新状态（0-未处理 1-已处理  2-已忽略）
     *
     * @param status
     */
    void updateStatus(Integer status, Long id, Long userId);
}
