/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.sys;

import java.util.Date;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.sys.HistoryBasic;
import cn.smarthse.modules.health.vo.base.historyBasic.BasicEntityContentSearch;


 /**
 * 
 * 《HistoryBasicService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017-12-21 11:19
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
@Transactional
public interface IHistoryBasicService extends IBaseService<HistoryBasic>{

	
	/**
	 * 更新实体信息到历史记录
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年1月2日-下午12:36:51
	 * @param newEntity 最新实体类信息，如果为空，则此方法不执行，直接返回。
	 * @param oldEntity 原有实体类信息，如果为空，则不对两个实体类进行比较，直接更新到历史记录表里面去。
	 * @param loginStaffId 当前登录用户ID
	 * @param cid 企业ID
	 */
//	void updateToHistory(Object newEntity,Object oldEntity,Long loginStaffId ,Long cid);
	
	/**
	 * 获取指定时间点的基础数据信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年1月2日-下午3:07:53
	 * @param id 基础数据ID
	 * @param date 时间点
	 * @return 指定时间点之前的最新基础数据信息。如果没有，则放回null
	 */
	Object getEntityByIdAndDate(Long id,Date date,String className);
	
	
	/**
	 * 获取实体类列表信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年11月13日-下午5:13:33
	 * @param id 实体类ID，如果为空，则type不能为空
	 * @param cid 企业ID，不能为空
	 * @param typeName 类型名称，见BasicEntitys的list列表，如果为空，则id不能为空
	 * @param date 时间点
	 * @param search 内容查询条件，如果是多个条件，则在list里面是多个。目前只有and的关系。
	 * @param uniqueKey 唯一字段属性，根据该字段，去重复。如果为空，则默认为id。例如：staffId。
	 * @return 指定时间点之前的最新基础数据信息。如果没有，则放回null
	 */
	List<Object> getEntityListByTypeCidIdAndDate(Long id,Long cid,String typeName,Date date,List<BasicEntityContentSearch> search,String uniqueKey);
	 /**
	  * 获取实体类列表信息
	  *
	  * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	  * @author horsy(何世壹) [hsy@smarthse.cn]
	  * @since 2018年11月13日-下午5:13:33
	  * @param id 实体类ID，如果为空，则type不能为空
	  * @param cid 企业ID，不能为空
	  * @param typeName 类型名称，见BasicEntitys的list列表，如果为空，则id不能为空
	  * @param year 时间点
	  * @param search 内容查询条件，如果是多个条件，则在list里面是多个。目前只有and的关系。
	  * @param uniqueKey 唯一字段属性，根据该字段，去重复。如果为空，则默认为id。例如：staffId。
	  * @return 指定指定年份内的的基础数据信息。如果没有，则放回null
	  */
	 List<Object> getEntityListByTypeCidIdAndYear(Long id,Long cid,String typeName,Integer year,List<BasicEntityContentSearch> search,String uniqueKey);
	
	/**
	 * 删除基础信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年11月13日-下午6:03:14
	 * @param basicId 基础信息ID
	 * @param loginStaffId 登录用户名
	 * @param cid 企业ID
	 * @param entityName 实体类的名称
	 */
//	void delHistoryBasic(Long basicId,Long loginStaffId ,Long cid,String entityName);
	
	/**
	 * 初始化企业的基础数据历史数据
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年12月13日-上午11:00:27
	 * @param cid
	 */
	void initHistoryBasic();


	 public void addHistoryBasic(HistoryBasic entity, Long loginStaffId, Long cid);

}
