package cn.smarthse.modules.health.service.standard;

import java.util.List;

import cn.smarthse.modules.health.entity.standard.L07LawStandard1List;
import cn.smarthse.modules.health.entity.standard.L07LawStandard2Relation;
import cn.smarthse.modules.health.entity.standard.L07LawStandard3Content;
import cn.smarthse.modules.health.vo.archive.ResultAttributeName;

public interface IStandardService {

	/**
	 * 根据标准号，查询标准列表
	 * @param titleNo 标准号
	 * @return
	 */
	public List<L07LawStandard1List> searchByTitleNo(String titleNo);
	
	/**
	 * 是否还有子节点。
	 * @param id
	 * @return
	 */
	public Boolean hasStandardRelationSub(Integer id);
	
	/**
     * 根据标准ID，和PID，获取标准内容列表（该列表，可能是目录，可能是内容）
     * @param standardId 标准ID 
     * @param pid L07LawStandard2Relation的PID，也是L07LawStandard3Content的ID
     * @return 列表
     */
	public List<L07LawStandard3Content> getStandardContentListByStandardIdAndPid(Integer standardId,Integer pid);
	
	/**
     * 根据标准ID，和PID，获取标准内容列表（该列表，可能是目录，可能是内容） 所有子内容
     * @param standardId 标准ID 
     * @param pid L07LawStandard2Relation的PID，也是L07LawStandard3Content的ID
     * @return 列表
     */
	public List<L07LawStandard3Content> getStandardContentListByStandardIdAndPidChildren(Integer standardId,Integer pid);
	
	/**
	 * 
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年8月31日-下午5:26:52
	 * @param parmaryKey
	 * @return
	 */
	public L07LawStandard2Relation getL07LawStandard2RelationByPrimaryKey(Integer parmaryKey);
	
	/**
	 * 
	 * 	根据危害因素编码及属性枚举，获取属性限值。
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年9月15日-上午11:13:07
	 * @param paramCode 危害因素编码
	 * @param attributeName 属性枚举
	 * @return 属性限值
	 */
	String getLimitValueByHarmfactorParamCodeAndAttribute(String paramCode,ResultAttributeName attributeName);
}
