package cn.smarthse.modules.health.service.litearchive.simple;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.vo.litearchive.TsLiteArchiveVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @author 邓力宾
 * @date 2021/4/27 14:01
 * @desc 档案接口
 */

public interface ILiteArchiveSimpleService extends IBaseService<LiteArchive> {

    /**
     * @param jqGridParam
     * @param cid
     * @param finish：
     *     finish参数为空：采用之前的逻辑，查询展示所有三同时档案；
     *     finish为false：采用之前的逻辑，查询展示所有三同时档案；
     *     finish为true：仅查询展示三同时项目已完成的档案列表。
     * @Comments: <三同时档案数据查询>
     * @author wujiacheng
     * @since 2022-7-26
     */
    public PageInfo<TsLiteArchiveVo> pageTsLiteArchiveVo(JqGridParam jqGridParam, String kw, Long cid, Boolean finish);

    /**
     * @description: 合规企业建设项目职业卫生“三同时”档案 档案列表数据（只展示已完成的）
     * @version: 卫企合规
     * @date: 2024-04-25 16:08
     * @param: 传参说明：
     * 		pageParam -> 分页参数
     * 		keyword ->   三同时项目名称关键字
     * 		cid ->       企业id
     * 	    finish ->
     *          finish参数为空：采用之前的逻辑，查询展示所有三同时档案；
     *          finish为false：采用之前的逻辑，查询展示所有三同时档案；
     *          finish为true：仅查询展示三同时项目已完成的档案列表。（3.2.2.1）
     * 		compliance -> 是否是卫企合规企业
     * @return: {@link PageInfo<TsLiteArchiveVo>} 三同时档案列表数据
     * @author: DengJia 18402894534@163.com
     */
    PageInfo<TsLiteArchiveVo> getTsLiteArchivePage(JqGridParam pageParam, String keyword, Long cid, Boolean finish, Boolean compliance);

    void addThreeArchiveSimple(TsProjectSimple tsProjectSimple, Long loginStaffId, Long cid) throws Exception;

    void updateThreeArchiveSimple(TsProjectSimple tsProjectSimple, Long loginStaffId) throws Exception;

    List<TsLiteArchiveVo> tsLiteArchiveVo(String kw, Long cid);
}
