package cn.smarthse.modules.health.service.litearchive;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.vo.litearchive.*;
import cn.smarthse.modules.health.vo.work.KeyCountVO;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author 邓力宾
 * @date 2021/4/27 14:01
 * @desc 档案接口
 */

public interface ILiteArchiveService extends IBaseService<LiteArchive> {

    /**
     * 档案列表查询
     * @param jqGridParam
     * @param cid
     * @param archiveType
     * @return
     */
    PageInfo<LiteArchive> queryPage(JqGridParam jqGridParam,Long cid, Integer archiveType);

    PageInfo<LiteArchiveVo> queryVoPage(JqGridParam jqGridParam, Long cid, Integer archiveType,boolean isComplianceCompany);

    /**
     * @Comments:  <三同时档案数据查询>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2021/4/29-11:07
     * @param jqGridParam
     * @param cid
     * @return com.github.pagehelper.PageInfo<cn.smarthse.modules.health.vo.litearchive.TsLiteArchiveVo>
    */
    public PageInfo<TsLiteArchiveVo> pageTsLiteArchiveVo(JqGridParam jqGridParam, String kw, Long cid);


    public void newUpdateStatus(Long archiveId, boolean isComplianceCompany);
    /**
     * 更新状态
     * @param id 档案id
     */
    void updateStatus(Long id);

    /**
     * 各种类型档案上传状态
     * @return
     */
    List<ArchiveTypeStatusVo> queryArchiveTypeStatus(Long cid);



    void isExistThisYearArchiveByCidAndType(Long cid, Integer archiveType,Long loginId);

    /**
     * 是否存在
     * @param cid
     * @param archiveType
     * @param year
     */
    boolean isExistArchiveByCidAndTypeAndYear(Long cid, Integer archiveType, String year);

    /**
     * @description: 参考上面的 isExistArchiveByCidAndTypeAndYear 方法实现的批量条件计数统计。
     * @version: 3.2.2.1
     * @date: 2023/6/15 16:53
     * @param: liteArchiveList 档案参数列表
     * @return: {@link List< KeyCountVO >}
     * @author: DengJia 18402894534@163.com
     */
    List<KeyCountVO> isExistArchiveByCidAndTypeAndYearBatch(List<LiteArchive> liteArchiveList, Long cid);

    /**
     * 创建按年份分组的档案（5:职业健康监护管理,4:职业病危害因素监测与检测评价,2:职业卫生管理档案,3:职业卫生宣传培训档案 6:劳动者）
     *
     */
    void autoCreateYearArchive(List<Long> cidList, String archiveTypes, String titles, boolean refreshArchiveItem);

//    void autoCreateYearArchive2(Long cid);//无异步任务
     /**
      *@Description: 浙江省项目档案可视化接口
      *@Author XiaoYi
      *@Date  2021/9/24  9:53
      *@param cid
      *@return ZjArchiveCountView
     **/
    ZjArchiveCountView getZjArchiveCountViewByCid(Long cid);

    /**
     * 获取已完成档案部分的企业（只要有一项里面一条完成的就可以）
     *
     * @param cidList cidList
     * @return {@code List<Long> }
     * @author zhangxu
     * @date 2023-05-25
     */
    Set<Long> getZjArchiveCountViewByCid(List<Long> cidList);

    /**
     * 职业卫生档案今年与上一年完善情况
     *
     * @param cid
     * @return {@link Map}
     * @author ShenZQ
     * @since 2023/3/8 15:27
     */
    Map<Integer, ZjArchiveCountView> getArchiveData(Long cid);

    /**
     * 职业卫生档案今年完善情况
     * @param cid
     * @return
     */
    ZjArchiveCountView getCurrentYearArchiveData(Long cid);

    /**
     * 获取六种档案状态
     * @param cid 企业id
     * @param year 年份
     * @return 档案类型->上传状态
     * 档案类型(1:三同时, 2:职业健康监护管理,3:职业病危害因素监测与检测评价,4:职业卫生管理档案,5:职业卫生宣传培训档案,6:劳动者)',
     * 状态 1：未上传 2：未完善 3：已完善
     */
    Map<Integer, Integer> getArchiveStatus(Long cid, String year);

    ZjArchiveCountView getLastZjArchiveCountViewByCid(Long cid);

    LiteArchive getFirstArchive5ByCid(Long companyId, Long loginStaffId);


    List<LiteArchive> getAllArchive(Integer archiveType);

    public List<LiteArchive> listLiteArchiveByCid(Long cid, Integer archiveType, String... years);

    public List<LiteArchive> listLiteArchiveByCids(List<Long> cids, List<Integer> archiveTypes, String... years);
    List<LiteArchive> getAllArchiveByYear(Integer year);

    void saveBatch(List<LiteArchive> newLiteArchiveList);


    public List<LiteArchive> getAllArchiveByTypeYear(Integer archiveType, String year);

    /**
     * 企业该年度已结束的培训数量
     * @param title 档案标题
     * @param cid cid
     * @return id
     */
    Long checkTrainFinishedDataByYear(String title, Long cid);

    /**
     * 企业该年度已通过监管审核/无需审核且处于有效期内的证书数量
     * @param title 档案标题
     * @param cid cid
     * @return id
     */
    Long checkCertStaffValidDataByYear(String title, Long cid);

    Map<String,Integer> getDoc5FileIdsStatus(ZjArchiveCountView view, Long cid, Boolean isCompliance);


    public List<LiteArchive> allLiteArchive(Date date,List<Integer> archiveTypeList, String[] archiveTitleArr);



    /**
     * 三同时填写的作证材料同步到档案1
     */
    void syncTsProjectArchive(TsProjectSimple tsProjectSimple);

    List<LiteArchive> listNoFileItemArchiveByCid(List<Long> cidList);


    public int batchInsertArchives(List<LiteArchive> liteArchives);


    public Long isComplianceCompany(Long cid);


    List<LiteArchiveFileDetailVo> listArchiveComplianceScoreVo(List<Long> cidList,
                                                                    List<Integer> archiveTypeList,
                                                                    List<String> titleList);

    List<LiteArchiveFileItem> queryComplianceArchive5Data(List<Long> cids);

    /**
     * @description: 批量查询三同时档案列表信息
     * @version: 卫企合规
     * @date: 2024-04-26 16:37
     * @param: 传参说明：
     * 		cidList -> 企业id列表
     * @return: {@link List<TsLiteArchiveVo>} 三同时档案列表
     * @author: DengJia 18402894534@163.com
     */
    List<TsLiteArchiveVo> queryComplianceTsLiteArchiveList(List<Long> cidList);

    /**
     * @description: 批量查询三同时档案详情数据
     * @version: 卫企合规
     * @date: 2024-04-26 16:39
     * @param: 传参说明：
     * 		archiveIdList -> 档案id列表
     * @return: {@link List<LiteArchiveFileDetailVo>} 档案详情数据
     * @author: DengJia 18402894534@163.com
     */
    List<LiteArchiveFileDetailVo> queryComplianceArchiveDetailList(List<Long> archiveIdList);


    List<LiteArchive> listNoFileItemArchive(List<Long> cidList,
                                            List<Integer> archiveTypeList,
                                            List<String> titleList,
                                            Integer status);
}
