package cn.smarthse.modules.health.service.litearchive;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.litearchive.CheckResultImportVo;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFilePersonal;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveHistoryFilePersonal;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.param.ArchiveSearchParam;
import cn.smarthse.modules.health.vo.archive.Archive503BaseInfoVo;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import com.github.pagehelper.PageInfo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author xiaoyi
 * @date 2021/4/27 14:01
 * @desc 个人档案
 */
public interface ILiteArchiveFilePersonalService extends IBaseService<LiteArchiveFilePersonal> {

    /**
     * 只查询人员和个人档案有效的
     * @param jqGridParam
     * @param param
     * @return {@code PageInfo<LiteArchiveFilePersonal> }
     * @author zhangxu
     * @date 2024-06-03
     */
    PageInfo<LiteArchiveFilePersonal> queryDetail(JqGridParam jqGridParam, ArchiveSearchParam param);

    /**
     * 获取企业中有档案的人员id
     *
     * @param cid
     * @param staffIds
     */
    List<Long> getStaffIdWithArchive(Long cid, List<Long> staffIds);

    /**
     * 获取档案列表是否有数据（只查询人员和个人档案有效的）
     * @param cids
     * @return {@code Set<Long> }
     * @author zhangxu
     * @date 2024-06-03
     */
    Set<Long> getHasArchiveCidList(List<Long> cids);

    /**
     * 职业健康在线：只看603是否完善，有个人体检或者整改算完成
     * 合规企业：602有检测就算完成，603有个人2年内体检算完成(如当前2024，2024-2就行了)，604有上传或登记算完成
     * @author zhangxu
     * @date 2024-06-04
     */
    //工作场所职业病危害因素检测结果--》获取检测
    public Map<Long,List<CheckPlan>> get602checkPlanMap(List<Long> cidList, Boolean iscompliance);
    //历次职业健康检查结果及处理情况--》获取体检信息  personalList->cid和idCard不能为空
    public Map<Long, Map<String, PhcPhysicalStaffCheckInfo>> get603phcPhysList(List<Long> cidList, List<String> idCardList, Boolean iscompliance);
    //历次职业健康检查结果及处理情况--》获取体检整改信息
    public Map<Long,List<ReformItemBasic>> get603reformMap(List<Long> cidList, Boolean isAll,Boolean iscompliance);

    //获取personals中全部完善的个人档案；职业健康在线是否完整：暂时只有查询列表用了，合规项是只有cid和staffId，最后用的staffId过滤
    public List<LiteArchiveFilePersonal> getCompletedPersonalList(List<LiteArchiveFilePersonal> personals, Boolean iscompliance);

    Integer getArchiveStatusByCid(Long cid);

    Boolean addFile(Long id, Long[] fileId2, Long cid, Long staffid,boolean isNowDoc);

    Boolean delFile(Long id, Long fileId, Long cid, Long staffid);

    Boolean isExist(Long cid, Long staffId);

    LiteArchiveFilePersonal addPersionArchive(LiteArchiveFilePersonal info) throws Exception;

    LiteArchiveFilePersonal updatePersionArchive(LiteArchiveFilePersonal info) throws Exception;

    /**
     * 批量更新个人档案
     * @param archiveIds
     * @param staffid
     * @return
     */
    Integer updatePersonalArchive(String archiveIds, Long staffid);

    Map<String, Object> getPersonalDocMap(Long cid,Long staffId);

    /*
     * @Description:添加接害人员到档案
     * @Author: XiaoYi(肖奕)
     * @Date: 2021/5/8 14:48
     * @param: [cid, archiveId]
     * @return: java.lang.Integer
     **/
    Integer addHarmWorkStaffToArchive(Long cid,Long archiveId,Long staffId);

    PageInfo<LiteArchiveHistoryFilePersonal> queryPersonalHistoryDataByPersonId(JqGridParam jqGridParam, Long personId);

    Boolean delPersonalHistoryDoc(Long id, Long cid, Long staffId);

    LiteArchiveHistoryFilePersonal getHistoryFilePersonalByHistoryId(Long historyId);

    List<Long> getArchiveStaffIdsByCid(Long cid);

    List<CheckResultImportVo> getCheckResultData(String ossfile, Long loginStaffId, Long cid);

    void importCheckResultData(List<CheckResultImportVo> importData,Integer year, Long cid, Long loginStaffId,Long fileId) throws FileNotFoundException, UnsupportedEncodingException;

    List<CheckResultImportVo> getFilePersonalList(Long cid);

    LiteArchiveFilePersonal getLiteArchiveFilePersonalByStaffId(Long staffId);

    void updataItemChild(Long fileId,Long archiveId,Long loginStaffId);

     /**
      *@ Description: <更新全部个人档案>
      *@ Author XiaoYi
      *@ Date  2022/1/17  10:09
      *@ param
      *@ return
     **/
    void updateAllPersonalArchive();

    List<LiteArchiveFilePersonal> getAllPersonalArchive();

    //获取有体检记录但没有档案的人员id
    List<Long> getNoArchiveStaffIdHasCheck(Long cid);

    List<Archive503BaseInfoVo> getArchive503BaseInfoByCid(Long cid);


    /**
     * 获取archive_file_item某类型的fileids是否为空
     *
     * @param archiveId  归档id
     * @param fileNameId 文件名称标识
     * @return {@code Integer }  -1参数缺失，0全部不为空，大于0有为空
     * @author zhangxu
     * @date 2023-05-24
     */
    Integer getArchiveFileItemNotNull(Long archiveId, Integer fileNameId);


    public List<LiteArchiveFilePersonal> getArchive6Staff(Long staffId,Long areaId, Byte areaLevel, Long cid);


    public List<Long> getArchive6StaffId();

    Map<Long, StaffInfo>  getCompletedNumByCidPersonal(List<Long> cids, Map<String,Object> map);

    /**
     * 单个企业批量新增个人档案
     * 原来：cn.smarthse.modules.health.service.litearchive.ILiteArchiveFilePersonalService#addPersionArchive(cn.smarthse.modules.health.entity.litearchive.LiteArchiveFilePersonal)
     * @param staffInfoIdList 为空时查询是否还有未生成的
     * @param cid
     * @param operateId
     * @param map
     * @author zhangxu
     * @date 2024-05-15
     */
    void addPersonalArchiveByCid(List<Long> staffInfoIdList, Long cid, Long operateId, Map<String,Object> map);

    /**
     * 个人档案批量登记
     *
     * @param archiveIds
     * @param cid
     * @param storageLocation
     * @param operateId
     * @param map
     * @return {@code Integer }
     * @author zhangxu
     * @date 2024-05-17
     */
    Integer batchUpdatePersonalRegister(List<Long> archiveIds, Long cid, String storageLocation, Long operateId, Map<String, Object> map);

    File getStaffDocInfoFile(Long cid, Long staffId);

    /**
     * 处理历史脏数据
     * @param cids
     * @return {@code String }
     * @author zhangxu
     * @date 2024-05-26
     */
    String handDirtyData(String cids);
}
