package cn.smarthse.modules.health.service.litearchive;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.enums.archive.ArchiveFilteItemDataStateEnum;
import cn.smarthse.modules.health.model.litearchive.ArchiveFileItemUpdateParam;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveFileDetailVo;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveFileItemVo;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

/**
 * @author 邓力宾
 * @date 2021/4/27 14:01
 * @desc 档案-文件名-附件
 */
public interface ILiteArchiveFileItemService extends IBaseService<LiteArchiveFileItem> {

    /**
     * 查询档案文件-附件详情
     * @param jqGridParam
     * @param id
     * @param staffId
     * @return
     */
    PageInfo<LiteArchiveFileDetailVo> queryDetail(JqGridParam jqGridParam, Long id, Long staffId,Boolean iscompliance);

    Map<Long, List<LiteArchiveFileDetailVo>> queryTsArchiveDetailGroup(List<Long> tsArchiveIdList, Boolean iscompliance);


    public List<LiteArchiveFileDetailVo> queryDetailList(Long id);
    public List<LiteArchiveFileDetailVo> queryDetailList(Long id, Boolean isCompliance);

    // 获取：合规企业建设项目职业卫生“三同时”档案，详细数据。
    List<LiteArchiveFileDetailVo> queryComplianceTsDetailList(Long id);

    /**
     * 更新（添加）附件
     * @param param
     * @return 返回 LiteArchiveFileItem 的id
     */
    Long updateArchiveFiles(ArchiveFileItemUpdateParam param);

    /**
     * 三同时删除 档案附件
     * @param archiveId
     * @param staffId
     * @return
     */
    public int delArchiveFiles(Long archiveId, Long staffId);
    /**
     * 已上传了附件的档案文件-计数
     * @param archiveId
     */
    Integer countByArchive(Long archiveId);

    /**
     * 档案-已完善数量
     * @return
     */
    Map<Long, Integer> archiveUploadNum();


    /**
     * 创建档案的附件
     * @param archive 当前档案
     */
    public void autoCreateFileItems(LiteArchive archive);

    public void autoCreateFileItems(LiteArchive archive, String fileNamdIds);

    /**
     * 创建档案的附件
     * @param liteArchiveId
     */
    void autoRefreshCreateFileItems(Long liteArchiveId);


    public void updateArchiveFileItemStatus(LiteArchive liteArchive);

    /**
     * 移除旧的来自系统的档案附件（更新档案附件时，要自动生成新的附件，所以要把旧的移除，用户上传的会保留）
     * @param liteArchiveId
     */
    void removeOldFromSystem(Long liteArchiveId);

    /**
     * 档案6专用
     * 移除旧的来自系统的档案附件（更新档案附件时，要自动生成新的附件，所以要把旧的移除，用户上传的会保留
     */
    void batchRemoveOldFromSystem(List<LiteArchiveFileItem> list);


    /**
     * 是否存在，存在返回id， 不存在返回null
     * @param archiveId
     * @param fileNameId
     * @return
     */
    Long exist(Long archiveId, Long fileNameId);

    /**
     * 查询
     * @param archiveId
     * @param fileNameId
     * @return
     */
    LiteArchiveFileItem getByArchiveAndFileName(Long archiveId, Long fileNameId);

    /**
     * 追加附件
     * @param archiveId
     * @param fileNameId
     * @param fromUserUpload 是否来自用户上传
     * @param isEmpty 是否空内容（空内容只存在到参考资料字段）
     */
    void appendFiles(Long archiveId, Long fileNameId, String fileIds, boolean fromUserUpload, boolean isEmpty);

    /**
     * 追加附件， 不更新状态， 状态在追加完后一起更新
     * @param archiveId
     * @param fileNameId
     * @param fileIds
     * @param referFileIds
     */
    public void appendFilesNotUpdateState(Long archiveId, Long fileNameId, String fileIds, String referFileIds);

    /**
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2023/5/18-10:34
     * @param archiveId
     * @param fileNameId
     * @param fileIds
     * @param referFileIds
     * @param dataState     数据完整情况， 1完整，
     * @return void
    */
    public void appendFilesNotUpdateState(Long archiveId, Long fileNameId, String fileIds, String referFileIds, ArchiveFilteItemDataStateEnum dataState);

    public void appendFilesNotUpdateState(Long archiveId, Long fileNameId, String fileIds, String referFileIds, ArchiveFilteItemDataStateEnum dataState, String jumpUrl);

    public void batchAppendFileItem(List<LiteArchiveFileItem> List);

    /**
     * 后面逐步淘汰上面两个方法
     * @param archiveId
     * @param fileNameId
     * @param fileIds
     * @param referFileIds
     * @param consumer
     */
    public void appendFileItem(Long archiveId, Long fileNameId, String fileIds, String referFileIds, Consumer<LiteArchiveFileItem> consumer);

    public void batchAppendFileItem(List<LiteArchiveFileItem> newList, Long archiveId, Integer archiveType, Long loginId);
    public void updateStorageLocation(LiteArchiveFileItem item, Long loginStaffId);

    List<LiteArchiveFileItem> getDoc5ListByLiteArchiveId(Long liteArchiveId,Integer year);

    /**
     * 根据档案查询
     * @param archiveId
     * @return
     */
    List<LiteArchiveFileItem> getByArchiveId(Long archiveId);

    /**
     * 同id获取档案文件信息（定时任务使用）
     * @param ids
     * @return
     */
    List<LiteArchiveFileItemVo> getListByLiteArchiveIds(List<Long> ids,Integer archiveType);


    void saveBatch(List<LiteArchiveFileItem> newItemList);

    /**
     * 通过cid查询某年份职业卫生机构成立文件的liteArchiveId和fileIds（sql限制了额一条）
     * @param cid
     * @param year
     * @return
     */
    LiteArchiveFileItem getLiteArchiveIdAndFileIds(Long cid,Integer year);

    /**
     * @Comments:  <档案调整， 获取要合并的档案>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2023/5/17-11:33
     * @param
     * @return java.util.List<cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem>
    */
    public void mergeData();
    public void mergeYearData();

    /**
     * @description: 判断档案内容是否有附件 并对数据状态做变更。
     * 判断一个或多个档案文件附件，视入参而定。
     *      - 有入参param.fileNameId：检测单个文件（fileNameId）附件
     *      - 无入参param.fileNameId：检测档案（archiveId）下的所有附件
     * 应用于栏目列表查询 和 单个文件附件增删
     *
     * @version: 3.2.2.1
     * @date: 2023/05/23 10:10:47
     * @param: [param,fileNameIdList] [档案附件更新参数, 需要统计已填写的档案文件id列表]
     * @return: void
     * @author: DengJia 18402894534@163.com
     */
    void judgeAndUpdateArchiveFilteItemDataState(ArchiveFileItemUpdateParam param, List<Long> fileNameIdList);

    List<LiteArchiveFileDetailVo> queryDetailAndSetUpdateStaffName(Long id, Integer archiveType);
}
