package cn.smarthse.modules.health.service.information;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.information.Information;
import cn.smarthse.modules.health.pojo.information.InformationQueryParam;
import com.github.pagehelper.PageInfo;

import java.util.Collection;
import java.util.List;

/**
 * @author 邓力宾
 * @date 2022/2/15 13:46
 * @desc
 */
public interface IInformationService extends IBaseService<Information> {

    /**
     * 查询
     * @param param
     * @return
     */
    PageInfo<Information> page(InformationQueryParam param);

    /**
     * 只查询id
     * @param param
     * @return
     */
    List<Long> getQueryAllIds(InformationQueryParam param);

    /**
     * 移除
     * @param ids
     * @param userId
     */
    void remove(String ids, Long userId);


    /**
     * 添加点击量
     */
    void addClickNum(Long id, int num);

    /**
     * 根据文章ID获取在线知识科普信息
     * @param textId
     * @return
     */
    Information getByTextId(Long textId);

}
