package cn.smarthse.modules.health.service.information;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.information.InformationKeyword;

import java.util.List;

/**
 * @author 邓力宾
 * @date 2022/2/15 13:47
 * @desc
 */
public interface IInformationKeywordService extends IBaseService<InformationKeyword> {


    /**
     * 添加
     * @param words
     * @param informationId
     * @param userId
     */
    void addWords(List<String> words, Long informationId, Long userId);

    /**
     * 获取最近添加的关键字
     * @param size 个数
     * @return
     */
    List<String> getCurrent(int size);

    /**
     * 查询
     * @return
     */
    List<String> getByInformationId(Long informationId);

    /**
     * 移除
     * @param informationId
     */
    void removeByInformationId(Long informationId);
}
