package cn.smarthse.modules.health.service.dtu;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.device.CameraRecord;

/**
 * @author Denglibin
 * @date 2022/1/5 9:18
 * @desc dtu物联网相关业务
 */
public interface IDtuService extends IBaseService<CameraRecord> {

    /**
     * 播放报警声音
     * @param deviceId dtu设备id
     * @param soundIndex 声音索引
     *                   3:请注意，现场进入的风险人员，请及时离开
     *                   4:请注意，现场监测的危害因素浓强度超标，请佩戴好防护有用品
     *                   5:请注意，现场监测的危害因素浓强度超标
     */
    void playAlarmSound(Long deviceId, int soundIndex);

    /**
     * 打开报警灯光
     * @param deviceId
     */
    void openAlarmLight(Long deviceId);

    /**
     * 关闭报警灯光
     * @param deviceId
     */
    void closeAlarmLight(Long deviceId);
}
