/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.workinfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;
import cn.smarthse.modules.health.entity.base.company.grade.vo.CompanyHarmNumVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkAreaInfo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkInfoImportVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkSearchVo;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author binxu(徐斌) [784514607@qq.com]
 * @since 2017-06-13 08:21
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IWorkRoleInfoService extends IBaseService<WorkRoleInfo>{

	PageInfo<WorkRoleInfo>  getWorkRoleInfoListByGridParm(JqGridParam param);

	PageInfo<WorkRoleInfo> getWorkRoleInfoListByParmPage(JqGridParam gparam, WorkSearchVo param);
	List<WorkRoleInfo> getWorkRoleInfoListByParm(WorkSearchVo param);

	List<WorkRoleInfo>  getWorkRoleInfoListForArchive(Long cid);

	/**
	 * 查询岗位和部门信息
	 *
	 * @param cid@return
	 */
	List<WorkRoleInfo> selectByParam(Long cid);

	 /**
	  * 查询该公司下所有岗位工种情况(未分页)
	  * @param cid
	  * @return 所有岗位列表
	  */
	List<WorkRoleInfo>  getWorkRoleInfoList(Long cid);

	List<WorkRoleInfo> getWorkRoleList(JqGridParam param);

	/**
	 * 
	 * @Comments:  <插入岗位/工种信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年6月14日-下午5:15:03
	 * @param wForm
	 * @param loginStaffId
	 * @param cid
	 * @return  返回数据是否已存在
	 */
	Boolean addWorkRoleInfoSubmit(WorkRoleInfo wForm,Long loginStaffId,Long cid) throws Exception;

	/**
	 * 
	 * @Comments:  <编辑岗位/工种信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年6月15日-上午10:20:49
	 * @param wForm
	 * @return 除了自己外是否存在相同的岗位
	 */
	Boolean editWorkRoleInfoSubmit(WorkRoleInfo wForm,Long loginStaffId,Long cid) throws Exception;

	/**
	 * 
	 * @Comments:  <通过ID删除岗位/工种信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年6月15日-下午2:50:11
	 * @param id
	 */
	void deleteWorkRoleInfoSubmit(Long id,Long loginStaffId,Long cid);

	/**
	 * 
	 * @Comments:  <根据当前企业Id获取岗位工种信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年6月23日-下午2:07:51
	 * @param cid
	 * @return
	 */
	List<WorkRoleInfo> getWorkRoleInfosByCid(Long cid);

	/**
	 * @Comments:  <获取岗位名称 和 岗位+组织名称>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2020/6/23-17:14
	 * @param cid
	 * @return java.util.List<cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo>
	*/
	public List<WorkRoleInfo> getWorkRoleOrgNameByCid(Long cid);
	/**
	 * 
	 * @Comments:  <根据工作名字获取岗位信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月4日-下午3:05:43
	 * @param work
	 * @param cid
	 * @return
	 */
	WorkRoleInfo getWorkRoleInfoByName(String workName, Long cid);
	/**
	 * 
	 * @Comments:  <根据cid删除岗位信息>
	 * @author xiaoyi
	 * @since 
	 * @param staffid
	 * @param cid
	 * @return
	 */
	void deleteWorkRoleByCid(Long cid, Long staffid);

	/**
	 * 
	 * @Comments:  <带有搜索功能>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年10月23日-下午1:27:06
	 * @param cid
	 * @param searchKey
	 * @return
	 */
	List<WorkRoleInfo> getWorkRoleInfosByCidAndSearch(Long cid, String searchKey,Long reWork);

	/**
	 * @Comments:  <根据 cid he 岗位名称关键字 获取岗位名称/组织名称 >
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2020/5/9-15:14
	 * @param cid
	 * @param searchKey
	 * @return java.util.List<cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo>
	*/
	List<WorkRoleInfo> getWorkRoleOrganByCidAndSearch(Long cid, String searchKey);

	/**
	 * 
	 * @Comments:  <根据岗位名字和组织名字获取岗位信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年8月10日-上午11:30:00
	 * @param workName
	 * @param orgName
	 * @param cid
	 * @return
	 */
	WorkRoleInfo getWorkRoleInfoByNameAndOrgName(String workName,String orgName, Long cid);
	WorkRoleInfo getWorkRoleInfoByNameAndOrgName2(String workName,String orgName, Long cid);

	
	/**
	 * 
	 * @Comments:  <根据cid获取岗位数据有效记录数>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年8月13日-下午4:04:47
	 * @param cid
	 * @return
	 */
	Integer getWorkInfoCountByCid(Long cid);

	Integer getWorkInfoCountByWorkNameAndOrgId(String workName, Long orgId, Long cid);

	List<WorkRoleInfo> getWorkInfoListWorkNameAndOrgId(String workName, Long orgId, Long cid);

	/**
	 * 根据岗位查岗位名称
	 * @param workId
	 * @return 包含有部门和删除情况
	 */
	String getWorkNameIncludeOrgName(Long workId);

	/**
	 * @param workId
	 * @param year
	 * @return  获取历史岗位名称
	 */
	String getHistoryWorkNameIncludeOrgNameByWorkIdAndYear(Long workId, Date year);

	List<WorkAreaInfo> getWorkAreaInfosByWorkId(Long workId);



	 /**
	  *
	  * @Comments:  <带有搜索功能>
	  * @author BinXu(徐斌) [784514607@qq.com]
	  * @since 2017年10月23日-下午1:27:06
	  * @param cid
	  * @param cid
	  * @param searchKey
	  * @return
	  */
     List<WorkRoleInfo> getWorkRoleInfosByCidAndOrgAndSearch(Long cid,Long orgId, String searchKey,Long reWork);


     List<WorkRoleInfo> getHarmWorkRoleInfosByCidAndOrgAndSearch(Long cid,Long orgId, String searchKey,Long reWork, List<String> harmTypeList);


     int addWorkRoleList(List<WorkRoleInfo> workList);

     List<WorkInfoImportVo> getWorkInfoFromExcel(String ossfile,Long loginStaffId,Long cid);

     int importWorkInfo(List<WorkInfoImportVo> list, Long cid, Long loginStaffId) throws Exception;

     /*
	 * @Description:
	 * @Author: XiaoYi(肖奕)
	 * @Date: 2020/12/6 9:23
	 * @param: [workName, orgName, cid]
	 * @return: cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo
	 **/
	 //WorkRoleInfo getWorkRoleInfoByNameAndOrg(String workName,String orgName, Long cid);

	 List<Long> getHisDataWorkAreaId(Long cid,Date date,Long workId);


     List<WorkRoleInfo> getCurrentAndPluralityWorkRoleInfosByCid(Long staffId);

	 public String getHarmNameByWorkRoleInfo(Long cid);

	 /**
	  *@ Description: <获取岗位危害因素列表>
	  *@ Author XiaoYi
	  *@ Date  2022/3/25  15:35
	  *@ param
	  *@ return
	 **/
	 List<HarmFactor>  getHarmfactorListByWork(Long workId, Long cid);
 /**
  *@ Description: <查询企业接触职业病危害因素总人数>
  *@ Author XiaoYi
  *@ Date  2022/3/17  16:21
  *@ param
  *@ return
 **/
	 Integer getContactHazardsStaffNumByCid(Long cid);
	 List<CompanyHarmNumVo> getContactHazardsStaffNumByCid2(Long cid);
	 /**
	  *@ Description: <从暴露风险数据添加部门和岗位>
	  *@ Author XiaoYi
	  *@ Date  2022/8/3  15:54
	  *@ param
	  *@ return
	 **/
	 public void addWorkAndDeptFormExposeData(Long cid,Long staffId);

     List<WorkRoleInfo> getWorkRoleInfosByCidAndOrgAndSearchExcludeChoose(Long cid, Long orgId, String searchKey, Long reWork);

     Map<String, WorkRoleInfo> getAllWorkRoleInfoByCids(Set<Long> cidSet);

 }

