/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */
package cn.smarthse.modules.health.service.base.wmbase;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.Company;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManage;
import cn.smarthse.modules.health.supervise.service.keyFactory.IApprovalDataSourceService;
import com.github.pagehelper.PageInfo;

import java.util.List;


/**
 * ipersonal保护装备记录服务
 *
 * @author zhangxu
 * @date 2023-05-10
 *///TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IWarnSignManageService extends IBaseService<WarnSignManage>, IApprovalDataSourceService {


    /**
     * 查询示警标识管理列表
     *
     * @param searchModel 搜索模式
     * @return {@code List<WarnSignManage> }
     * @author zhangxu
     * @date 2023-05-10
     */
    List<WarnSignManage> getListSignManageBySearchModel(WarnSignManage searchModel);
    PageInfo<WarnSignManage> getPagesSignManageBySearchModel(JqGridParam jqGridParam, WarnSignManage searchModel);

    /**
     * 通过id删除示警标识管理记录
     * 逻辑删除
     *
     * @param ids           ids
     * @param loginStaffId 登录员工id
     * @return {@code Integer }
     * @author zhangxu
     * @date 2023-05-11
     */
    Integer deleteByIds(List<Long> ids, Long loginStaffId);

    /**
     * 通过id删除个人防护用品记录
     * 物理删除
     *
     * @param ids           ids
     * @return {@code Integer }
     * @author zhangxu
     * @date 2023-05-11
     */
    Integer deleteByIds(List<Long> ids);

    /**
     * 克隆记录
     *
     * @param id           id
     * @param loginStaffId 登录员工id
     * @return {@code WarnSignManage }
     * @author zhangxu
     * @date 2023-05-11
     */
    WarnSignManage cloneSignManage(Long id, Long loginStaffId);

    /**
     * 保存或提交记录
     *
     * @param signManage       记录
     * @param changeState  改变状态
     * @return {@code WarnSignManage }
     * @author zhangxu
     * @date 2023-05-11
     */
    WarnSignManage saveOrSubmitSignManage(WarnSignManage signManage, Integer changeState);

    /**
     * 变更记录类型，会清空数据
     *
     * @param id           id
     * @param reportType   报告类型
     * @param loginStaffId 登录员工id
     * @return {@code Integer }  1成功，0失败
     * @author zhangxu
     * @date 2023-05-11
     */
    Integer changeRecordReportType(Long id, Integer reportType, Long loginStaffId);

    /**
     * 获取某企业或所有，有记录的年份
     *
     * @param cid 登录公司员工id  为空是查询所有
     * @return {@code List<Integer> }
     * @author zhangxu
     * @date 2023-05-12
     */
    List<Integer> getAllRecordYearBySearch(Long cid);

    /**
     * 通过最新一次检测生成添加记录
     *
     * @param param 参数
     * @return {@link WarnSignManage }
     * @author zhangxu
     * @date 2023-05-14
     */
    WarnSignManage addRecordByCheck(WarnSignManage param);


    public List<WarnSignManage> getFullSignManage(WarnSignManage searchModel);

    /**
     * 获取该企业最近两年已审核、无需审核的数量
     *
     * @param cid cid
     * @return {@code Integer }
     * @author zhangxu
     * @date 2023-05-19
     */
    public Integer getLastTwoYearsCompletedNum(Long cid);

    /**
     * 验证数据
     *
     * @param searchModel 搜索模式
     * @return {@code String }
     * @author zhangxu
     * @date 2023-05-26
     */
    public String verifyData(WarnSignManage searchModel);

    /**
     * 设置为终止状态
     *
     * @param signManage
     * @param loginStaffId   登录员工id
     * @param currentCompany
     * @return {@code String }
     * @author zhangxu
     * @date 2023-06-19
     */
    Long setTermination(WarnSignManage signManage, Long loginStaffId, Company currentCompany);

    /**
     * 三年内企业最新一条警示标识数据 合规企业13小项数据
     * @param cids
     * @return
     */
    List<WarnSignManage> selectLatestData(List<Long> cids);
}
