/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.thirdparty;

import java.util.Date;
import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.thirdparty.TpCompany;
import cn.smarthse.modules.health.enums.thirdparty.TpCompanyTypeEnum;


 /**
 * 
 * 《TpCompany》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2017-06-15 06:12
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ITpCompanyService extends IBaseService<TpCompany>{

	/**
	 * 
	 * 
	 * @Comments:  根据对象是否有主键id 判断做更新还是创建操作
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017-06-15 06:12
	 * @param TpCompanyVo
	 * @param loginStaffId
	 * @param cid
	 * @return
	 * @throws Exception
	 */
	public TpCompany saveOrUpdateTpCompany(TpCompany tpCompany, Long loginStaffId,Long cid) throws Exception;

	/**
	 * 
	 * 
	 * @Comments:  <默认存在评价与检测机构建安>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年12月28日-上午9:42:34
	 * @param cid
	 * @throws Exception
	 */
	public void initDefaultTpCompany(Long cid) throws Exception;
	/**
	 * 
	 * 
	 * @Comments: 获取第三方信息（带分页）
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年6月20日-上午10:26:42
	 * @param page
	 * @param isBacklist （true 获取黑名单的数据）
	 * @return
	 */
	public PageInfo<TpCompany> getTpCompanyPage(JqGridParam param, Boolean isBacklist, String typeName, String searchKw) ;
	/**
	 * 
	 *   
	 * @Comments:  移入黑名单
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年6月20日-上午10:25:37
	 * @param tpCompany
	 * @param loginStaffId
	 */
	public void updateTpCompany2Backlist(TpCompany tpCompany, Long loginStaffId) ;
	/**
	 * 
	 * 
	 * @Comments:  获取所有第三方信息
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年6月20日-上午10:57:10
	 * @return
	 */
	public List<TpCompany> getAllTpCompany();


	 /**
	  * @Comments:  <获取第三方 归档记录>
	  * @author zhoulj(周利军) [1217102780@qq.com]
	  * @since 2019/1/16-14:21
	  * @param tpId
	  * @param date
	  * @return cn.smarthse.modules.health.entity.base.thirdparty.TpCompany
	  */
	 public TpCompany getArchiveTpCompany(Long tpId, Date date);
	 /**
	 * 
	 * 
	 * @Comments:  根据对象属性 查询数据列表
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年6月28日-下午1:18:30
	 * @return
	 */
	public List<TpCompany> getTpCompanyList(TpCompany param);
	
	/**
	 * 
	 * 
	 * @Comments:  <根据企业类型获取企业列表， getCertifi==true表示要获取企业证书， certifiName为证书名称>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年8月30日-上午10:07:13
	 * @param tpcType
	 * @param cid
	 * @return
	 */
	@Deprecated
	public List<TpCompany> getTpCompanyListByType(TpCompanyTypeEnum tpcType, Long cid, boolean getCertifi, String certifiName);
	
	
	public List<TpCompany> getTpCompanyListByType(TpCompanyTypeEnum tpcType, Long cid, boolean getCertifi, String certifiName, Date date);
	
	/**
	 * 
	 * 
	 * @Comments:  <根据企业id获取第三方企业数量>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2018年8月13日-下午3:52:03
	 * @param cid
	 * @return
	 */
	public Integer countTpCompanyByCid(Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <根据企业类型分类 分别统计数量>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2018年8月15日-上午10:00:07
	 * @param cid
	 * @return
	 */
	public List<TpCompany> countTpCompanyType(Long cid);
	
	public ResponseData<List<TpCompany>> importTpCompanyForExcel(String ossfile, Long cid,Long loginStaffId);
	
	public String getTpCompanyNameDelFlag(Long id) ;

	public void delTpCompany(TpCompany tc, Long loginStaffId, Long cid);
}
