/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.thirdparty;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.thirdparty.TpCertificate;


 /**
 * 
 * 《TpCertificate》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2017-06-21 11:40
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ITpCertificateService extends IBaseService<TpCertificate>{

	/**
	 * 
	 * 
	 * @Comments:  根据对象是否有主键id 判断做更新还是创建操作
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017-06-21 11:40
	 * @param TpCertificate
	 * @param loginStaffId
	 * @param cid
	 * @return
	 * @throws Exception
	 */
	public TpCertificate saveOrUpdateTpCertificate(TpCertificate tpCertificate, Long loginStaffId,Long cid) throws Exception;

	/**
	 * 
	 * 
	 * @Comments:  根据证书名称批量删除第三方证书
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年6月27日-下午5:01:08
	 * @param tpCertificate
	 * @param loginStaffId
	 * @return
	 * @throws Exception
	 */
	public int delCertifiByName(TpCertificate tpCertificate, Long loginStaffId) throws Exception;
	/**
	 * 
	 * 
	 * @Comments:  根据第三方ID 获取对应的证书列表（同个类型的证书 取时间最新的）<br>
	 * 			这里会忽略 有效期时间为空的数据
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年6月21日-下午7:00:00
	 * @param param
	 * @return
	 */
	public PageInfo<TpCertificate> getTpCertifiList4MaxVality(JqGridParam gparam,Long tpId);
	
	/**
	 * 
	 * 
	 * @Comments: 根据企业证书名称和tpId获取证书列表
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年6月26日-上午10:24:22
	 * @param gparam
	 * @param tpId
	 * @param certifiName
	 * @return
	 */
	public PageInfo<TpCertificate> getTpCertifiListByName(JqGridParam gparam,Long tpId,String certifiName);

	public void delCertifi(TpCertificate tpcertifi, Long loginStaffId) throws Exception;
	
	/**
	 * 
	 * 
	 * @Comments:  <获取指定第三方的证书信息 ，  获取有效期最长的>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年11月16日-上午10:33:38
	 * @param tpId
	 * @param certifiName
	 * @return
	 */
	public TpCertificate getMaxValityTpCertificate(Long tpId, String certifiName );

	/**
	 * 
	 * 
	 * @Comments:  <批量保存第三方企业证书>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2018年6月28日-下午6:58:34
	 * @param tpcertifiList
	 * @param cid
	 * @param loginStaffId
	 */
	public void batchSave(List<TpCertificate> tpcertifiList, Long cid, Long loginStaffId)  throws Exception;
	
}
