/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.staff;

import java.util.List;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.WorkNatureInfo;


/**
 * 《作业性质服务》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author XiaoYi（肖奕)
 * @since 2020年5月26日-上午10:45:46
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IWorkNatureInfoService extends IBaseService<WorkNatureInfo>{


		/**
		 * 添加人员默认作业信息
		 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
		 * @author  XiaoYi（肖奕)
		 * @since 2020年5月26日-上午10:50:23
		 * @param staffId
		 * @param cid
		 */
		void addDefaultInfoByStaffId(Long staffId,Long cid);
		
		
		/**
		 * 获取人员从业性质列表
		 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
		 * @author  XiaoYi（肖奕)
		 * @since 2020年5月26日-上午11:13:32
		 * @param param
		 * @param staffId
		 * @return
		 */
		PageInfo<WorkNatureInfo> getWorkNatureInfoByStaffId(JqGridParam param,Long staffId);
		
		
		/**
		 * 判断人员是否有从业性质数据如无，则添加默认数据
		 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
		 * @author  XiaoYi（肖奕)
		 * @since 2020年5月26日-上午11:42:55
		 * @param staffId
		 * @return
		 */
		Boolean haveWorkNatureDataByStaffId(Long staffId,Long cid);


		/**
		 * 获取企业放射或特种作业人员列表
		 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
		 * @author  XiaoYi（肖奕)
		 * @since 2020年6月29日-上午9:04:13
		 * @param cid
		 * @param type
		 * @return
		 */
		List<WorkNatureInfo> getWorkInfoListByCid(Long cid, Byte type);

}
