/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.staff;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.staff.importstaff.BatchStafffWorkVo;
import cn.smarthse.modules.health.entity.base.staff.vo.ImproveStaffModel;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;


 /**
 *
 * 《xxxService》
 *
 *
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @author binxu(徐斌) [784514607@qq.com]
 * @since 2017-06-13 08:27
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IStaffWorkRoleService extends IBaseService<StaffWorkRole>{

	/**
	 *
	 * @Comments:  <根据人员ID获取当前具体岗位信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年6月20日-下午6:41:47
	 * @param staffId
	 * @return
	 */
	StaffWorkRole getCurrentStaffWorkRoleByStaffId(Long staffId);

	/**
	 *
	 * @Comments:  <根据人员ID获取厂内工作经历>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年6月20日-下午6:55:27
	 * @param staffId
	 * @return
	 */
	List<StaffWorkRole> getLocalStaffWorkRolesByStaffId(Long staffId);


	/**
	 *
	 * @Comments:  <根据人员ID获取厂内工作经历>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月9日-下午6:55:27
	 * @param staffId
	 * @return
	 */
    List<StaffWorkRole> getLocalStaffWorkRolesByStaffIdOrderByBeginTime(Long staffId);

	/**
	 *
	 * @Comments:  <根据人员ID获取厂外工作经历>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年6月20日-下午6:59:02
	 * @param staffId
	 * @return
	 */
	List<StaffWorkRole> getOutsideStaffWorkRolesByStaffId(Long staffId);

	/**
	 *
	 * @Comments:  <根据人员岗位信息ID获取数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年6月26日-下午5:08:20
	 * @param staffWorkRoleId
	 * @return
	 */
	StaffWorkRole getStaffWorkRoleById(Long staffWorkRoleId);

	/**
	 *
	 * @Comments:  <根据人员信息ID获取兼职岗位>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年6月28日-下午5:43:35
	 * @param staffId
	 * @return
	 */
	List<StaffWorkRole> getPluralityStaffWorkRolesByStaffId(Long staffId);

	/**
	 *
	 * @Comments:  <根据人员信息ID获取所有兼职岗位信息包括数据无效的>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年6月29日-上午8:48:00
	 * @param staffId
	 * @return
	 */
	List<StaffWorkRole> getAllPluralityStaffWorkRolesByStaffId(Long staffId);

	/**
	 *
	 * @Comments:  <根据人员ID获取厂内工作经历>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月10日-下午1:18:52
	 * @param staffInfoId
	 * @return
	 */
	PageInfo<StaffWorkRole> getLocalStaffWorkRolesDataByStaffId(JqGridParam  jparam,Long staffInfoId);

	/**
	 *
	 * @Comments:  <根据人员ID获取厂外工作经历>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月10日-下午3:56:04
	 * @param jparam
	 * @param staffInfoId
	 * @return
	 */
	PageInfo<StaffWorkRole> getOutsideStaffWorkRolesDataByStaffId(JqGridParam jparam, Long staffInfoId);

	/**
	 *
	 * @Comments:  <根据岗位获取当前的岗位和兼职岗位信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月11日-上午9:18:40
	 * @param workId
	 * @param cid
	 * @return
	 */
	List<StaffWorkRole> getStaffWorkRoleByCidAndWorkIdAndNoHistory(Long workId, Long cid);


	/**
	 *
	 * @Comments:  <根据岗位获取当前的岗位信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月11日-上午9:18:40
	 * @param workId
	 * @param cid
	 * @return
	 */
	List<StaffWorkRole> geCurrenttStaffWorkRoleByCidAndWorkIdAndNoHistory(Long workId, Long cid);

	/**
	 *
	 * @Comments:  <判断该人员是否新增的依据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月21日-下午4:46:06
	 * @param loginStaffId
	 * @param cid
	 * @return
	 */
	Boolean getIsFirstEditWorkBy(Long staffInfoId,Long loginStaffId, Long cid);

	/**
	 *
	 * @Comments:  <根据人员信息IDs，上岗时间，离岗时间，企业Id查询具体的岗位信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年1月2日-下午1:31:27
	 * @param staffIds
	 * @param beginWorkTime
	 * @param endWorkTime
	 * @param cid
	 * @return
	 */
	List<StaffWorkRole> getStaffWorkRoleByStaffIdsAndStartDateAndEndDateAndCid(String staffIds,Date beginWorkTime,Date endWorkTime,Long cid);


	StaffWorkRole  addStaffWorkRoleSubmit(StaffWorkRole staffWorkRole,Long loginStaffId,Long cid);

	void   editStaffWorkRoleSubmit(StaffWorkRole staffWorkRole,Long loginStaffId,Long cid);

	StaffWorkRole getCurrentStaffWorkRoleIncludeNoIsValidByStaffId(Long staffId);

	/**
	 *
	 * @Comments:  <根据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年8月6日-上午10:21:22
	 * @param workIds
	 * @return
	 */
	Integer getCurrentOnWorkStaffCountByWordIds(List<Long> workIds,Long cid);

	/**
	 *
	 * @Comments:  <获取厂内工作经历数据>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年8月28日-上午9:01:45
	 * @param staffInfoId
	 * @return
	 */
	List<StaffWorkRole> getLocalStaffWorkRolesDataByStaffId(Long staffInfoId);

	void deleteStaffWorkRoleByStaffWorkRoleId(Long staffWorkRoleId,Long loginStaffId, Long cid);

	StaffWorkRole getCurrentStaffWorkRoleHistoryCompanyIncludeNoIsValidByStaffId(Long staffId);

	/**
	 * 获取人员某个岗位历史记录
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2020年7月17日-下午7:24:36
	 * @param staffId
	 * @param workRoleId
	 * @return
	 */
	StaffWorkRole getCurrentStaffWorkRoleHistory(Long staffId,Long workRoleId);

	/**
	 * 获取人员在某个时间的岗位信息
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2020年5月26日-下午3:43:35
	 * @param staffId
	 * @param beginTime
	 * @param endTime
	 * @return
	 */
	StaffWorkRole getStaffWorkRoleHistoryByStaffIdAndTime(Long staffId,Date beginTime,Date endTime);


	 /**
	  * 根据用户查询他们的岗位（合集）v2.9 邓力宾 2019-10-12 16：12
	  * @param staffIds
	  * @return
	  */
	List<Long> getWorkIdsByStaffIds(List<Long> staffIds);

	/**
	 *
	 * @Comments:  <批量转岗离岗操作>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年12月11日-上午10:00:13
	 * @param type
	 * @param vo
	 */
	void batchStaffWorkSubmit(Integer type, BatchStafffWorkVo vo,String isSharingSystem);


	/**
	 * 获取人员工作记录
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2020年5月29日-下午1:54:04
	 * @param jparam
	 * @param staffId
	 * @return
	 */
	PageInfo<StaffWorkRole> getStaffWorkRolesDataByStaffId(JqGridParam  jparam,Long staffId);


	/**
	 * 判断历史记录是否包含当前岗位
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2020年6月11日-上午10:25:04
	 * @param staffId
	 * @return
	 */
	Boolean isHaveCurrentRoleInHistory(Long staffId);

	/*
	 * @Description:获取岗位人数
	 * @Author: XiaoYi(肖奕)
	 * @Date: 2020/10/13 15:05
	 * @param: [workId, cid]
	 * @return: java.lang.Integer
	 **/
	Integer getWorkerNumByWorkId(Long workId,Long cid);

	 /**
	  * 获取员工信息
	  *
	  * @param orgId
	  * @param cid
	  * @param trainId
	  * @param staffName
	  * @param sortBy
	  * @return
	  */
	List<StaffWorkRole> getChooseStaff(Long orgId, Long cid, Long trainId, String staffName, Byte sortBy);

 /**
  *@ Description: <获取岗位女工人数>
  *@ Author XiaoYi
  *@ Date  2022/7/26  16:13
  *@ param
  *@ return
 **/
	 Integer getFemaleWorkerNumByWorkId(Long workId,Long cid);
	/*
	 * @Description:获取本企业或第三方岗位人数
	 * @Author: XiaoYi(肖奕)
	 * @Date: 2021/1/12 14:11
	 * @param: [workId, cid]
	 * @return: java.lang.Integer
	 **/
	 Integer getSelfComOrThirdWorkerNumByWorkId(Long workId,Long cid,Boolean isThird);

	/*
	 * @Description:获取人员所属部门
	 * @Author: XiaoYi(肖奕)
	 * @Date: 2020/10/13 15:05
	 * @param: []
	 * @return: java.util.List<cn.smarthse.modules.health.entity.base.company.CompanyOrganization>
	 **/
	List<CompanyOrganization> getStaffOrgByStaffId(Long staffId);

	/*
	 * @Description:获取离岗人员id列表
	 * @Author: XiaoYi(肖奕)
	 * @Date: 2021/8/20 13:56
	 * @param: [cid]
	 * @return: java.util.List<java.lang.Long>
	 **/
	List<Long> getOutWorkStaffIdList(Long cid);

/*
* @Comments:  <华东更新当前岗位离岗>
* @author BinXu(徐斌) [784514607@qq.com]
* @since 下午3:15 2021/8/24
**/
     void updateCurrentStaffWorkRoleNotWorkedByStaffId(Long staffId);

     List<Long> getNeedSetStatusCids();

     int updateBatchWorkStatus(List<StaffWorkRole> updateList);
     int updateBatchWorkTime(List<ImproveStaffModel> updateList);

	 /**
	  * 批量获取人员岗位信息
	  *
	  * @param staffIdList 人员id列表
	  * @return 人员岗位信息
	  */
	 List<StaffWorkRole> getStaffWorkRoleListBatch(List<Long> staffIdList);

	 /**
	  * 设置老数据的首次上岗时间
	  */
	 void setFirstBeginTime();

     Byte getWorkStatus(Long cid, String idCard);
 }
