package cn.smarthse.modules.health.service.base.staff;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.compliance.vo.ComplianceStaffInfoVo;
import cn.smarthse.modules.health.entity.base.staff.*;
import cn.smarthse.modules.health.entity.base.staff.importstaff.BatchStafffWorkVo;
import cn.smarthse.modules.health.entity.base.staff.importstaff.StaffInfoExcelImportVo;
import cn.smarthse.modules.health.entity.base.staff.importstaff.StaffInfoNeedImportVo;
import cn.smarthse.modules.health.entity.base.staff.vo.*;
import cn.smarthse.modules.health.entity.work.check.vo.HudongSysStaffInfoVo;
import cn.smarthse.modules.health.enums.staff.StaffListHeaderEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.platform.model.UserModel;
import com.github.pagehelper.PageInfo;
import org.apache.poi.hssf.usermodel.HSSFSheet;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 《xxxService》
 *
 * @author binxu(徐斌) [784514607@qq.com]
 * @Project: GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @since 2017-06-12 05:15
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IStaffInfoService extends IBaseService<StaffInfo> {


    PageInfo<StaffShowInfo> getStaffInfoListBySearchParam(StaffInfoSearchParam param);

    Integer getStaffCount(StaffInfoSearchParam param);

    /**
     * @param param
     * @return 未分页信息
     */
    List<StaffShowInfo> getStaffInfoListByParam(StaffInfoSearchParam param);
    List<StaffShowInfo> getLaborDispatchStaffInfoListBySearchParam(StaffInfoSearchParam param);

    /**
     * @param staffInfo
     * @Comments: <人员基础信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年6月20日-下午1:22:42
     */
    StaffInfo addStaffInfoSubmit(StaffInfo staffInfo);

    /**
     * @param staffId
     * @return
     * @Comments: <根据ID获取人员所有相关信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年6月20日-下午5:02:05
     */
    StaffInfo getStaffInfoDetailById(Long staffId);
    /**
     * @param staffId
     * @return
     * @Comments: <根据ID获取人员所有相关信息,岗位和部门>
     * @author xiaoyi
     * @since 2022年11月28日-下午5:02:05
     */
    StaffInfo getStaffInfoWorkAndDeptById(Long staffId);

    /**
     * 根据员工ID，获取员工的姓名
     *
     * @param staffId
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年8月8日-下午3:49:31
     */
    String getStaffNameByStaffId(Long staffId);

    /**
     * 根据员工ID字符串，获取员工姓名字符串
     *
     * @param staffIdStr
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2017年9月6日-下午2:59:11
     */
    String getStaffNamesByStaffIds(String staffIdStr);


    /**
     * @param cid
     * @return
     * @Comments: <根据组织架构ID获取人员所有相关信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年6月21日-下午5:03:35
     */
    List<StaffInfo> getStaffInfoDetailByOrgId(Long cid, Long orgId, String searchKey, Long workRoleInfoId);

    /**
     * 读取人员信息（附带人员工作信息）
     *
     * @param staffId
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-6-22-下午4:33:13
     */
    StaffInfo getStaffInfoWithStaffBasicWorkById(Long staffId);

    /**
     * @param staffInfo
     * @param loginStaffId
     * @Comments: <更新人员基础信息和生理特征>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年6月28日-下午1:39:32
     */
    void editStaffInfoSubmit(StaffInfo staffInfo, Long loginStaffId);


    /**
     * @param staffInfoId
     * @param deleteReason  人员删除原因
     * @Comments: <根据人员ID逻辑删除人员所有相关信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年7月2日-下午5:11:43
     */
    void deleteStaffInfoById(Long staffInfoId, Long loginStaffId, String deleteReason);


    /**
     * @param ossfile
     * @param cid
     * @return
     * @Comments: <从第三方人员Excel表中获取数据> 目前三同时在用
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年7月5日-下午1:27:09
     */
    public ResponseData<StaffInfoImportVo> getStaffBatchInfoFromExcelForThird(String ossfile, Long cid) throws Exception;

    /**
     * @param ossfile
     * @param cid
     * @return
     * @throws Exception
     * @Comments: <从本企业人员Excel表中获取数据> 三同时
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年7月5日-下午1:29:36
     */
    public ResponseData<StaffInfoImportVo> getBatchStaffInfoFromExcelForSelf(String ossfile, Long cid) throws Exception;


    /**
     * @param cid
     * @return
     * @Comments: <根据企业ID获取人员信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年7月8日-下午1:13:29
     */
    public List<StaffInfo> getStaffInfoListByCid(Long cid);

    /**
     * @param cid
     * @return
     * @Comments: <获取当前企业人员信息数量>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年7月10日-上午9:16:46
     */
    public Integer getStaffInfoCountByCid(Long cid);


    /**
     * 通过平台创建员工信息
     *
     * @param cid      企业编号
     * @param userinfo 用户信息
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-7-19-下午3:40:51
     */
    StaffInfo addStaffInfoByPlatform(Long cid, UserModel userinfo);


    /**
     * @param vo
     * @param loginStaffId
     * @param cid
     * @return (key - value): (noImportStaffBasicInfos-List<StaffBasicInfo>)和(successStaffInfo-Collect<StaffInfo>)
     * @Comments: <三同时人员导入>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年7月26日-上午10:18:20
     */
    public Map<String, Object> batchImportStaffInfoForThirdTime(StaffInfoImportVo vo, Long loginStaffId, Long cid);


    /**
     * @param ossfile
     * @param cid
     * @return 返回的是以sheetname(本企业和劳动外派 ( 可在StaffExcelSheetNameEnum进行更改))为key,
     * value为ResponseData<StaffInfoImportVo>里面存储了从excel取出的数据和校验
     * @Comments: <从初始化人员Excel表中获取数据 >
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年7月5日-下午1:27:09
     */
    public Map<String, ResponseData<StaffInfoImportVo>> getStaffBatchInfoFromExcelForInit(String ossfile, Long cid) throws Exception;


    /**
     * @param cid
     * @Comments: <初始化删除当前除自己之外的人员信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年7月30日-下午4:34:47
     */
    public void deletestaffInfosNotSelfForInit(Long cid, Long loginStaffId);


    /**
     * @param staffInfoId          人员信息Id
     * @param changedWorkId        岗位变更后的岗位Id
     * @param currentWorkLeaveTime 当前岗位的离岗时间
     * @param nowWorkBeginTime     变更后的岗位的上岗时间
     * @param nowWorkStatus        岗位状态
     * @Comments: <岗位变更接口>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年8月2日-下午1:52:45
     */
    public void staffCurrentWorkInfoChangeInform(Long staffInfoId, Long changedWorkId, Date currentWorkLeaveTime, Date nowWorkBeginTime, StaffWorkStatusEnum nowWorkStatus, Long loginStaffId, Long cid);

    /**
     * @param staffId
     * @return
     * @Comments: 根据staffid获取员工基础信息
     * @author yanao [ya@smarthse.cn]
     * @since 2017年8月9日-下午3:19:12
     */
    public StaffBasicVo getStaffBasicInfoById(Long staffId);

    /**
     * @param cid
     * @param staffName
     * @param idCard
     * @return
     * @Comments: 根据员工企业、员工名称、员工身份证获取员工基本信息
     * @author yanao [ya@smarthse.cn]
     * @since 2017年8月12日-上午11:55:56
     */
    public StaffBasicVo getStaffInfoByQuery(Long cid, String staffName, String idCard);

    public List<StaffBasicVo> getStaffInfoByIdCard(Long cid, String idCard);

    public StaffBasicVo getOrAddStaffInfoByQuery(Long cid, String staffName, String idCard, String workName, String harmIds,Byte dataSource);


    /**
     * @param cid
     * @return
     * @Comments: <根据cid获取职业健康档案人员相关数据:严熬>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年8月31日-下午1:26:18
     */
    public List<StaffhealthDocVo> getStaffhealthDocVoDatasByCid(Long cid);

    /**
     * @param staffInfoId          人员信息Id
     * @param changedWorkId        岗位变更后的岗位Id
     * @param currentWorkLeaveTime 当前岗位的离岗时间
     * @param nowWorkBeginTime     变更后的岗位的上岗时间
     * @param nowWorkStatus        岗位状态
     * @param loginStaffId
     * @param cid
     * @Comments: <岗位变更>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年8月2日-下午1:52:45
     */
    public void currentWorkChangeInorm(Long staffInfoId, Long changedWorkId, Date currentWorkLeaveTime, Date nowWorkBeginTime, StaffWorkStatusEnum nowWorkStatus, Long loginStaffId, Long cid);


    /**
     * @param staffId
     * @return
     * @throws Exception
     * @Comments: <劳动者个人信息卡:何>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年9月8日-下午1:39:47
     */
    public StaffDocInfoVo getStaffDocInfoVoByStaffId(Long staffId);


    /**
     * @param staffId
     * @return
     * @throws Exception
     * @Comments: <劳动者个人信息卡:工作场所职业病危害因素检测结果:何>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年9月8日-下午1:39:47
     */
    public List<StaffCurrentWorkVo> getStaffCurrentWorkVoByStaffId(Long staffId);


    /**
     * @param cid
     * @param staffId
     * @return 是否有危害因素
     * @Comments: <没有做岗位职业卫生检测的人员列表:何>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年9月10日-下午12:22:03
     */
    public Integer getNoWorkCheckStaffIdsByCidAndStaffIds(Long cid, Long staffId);


    /**
     * @param workId
     * @param cid
     * @return
     * @Comments: <根据岗位获取当前的岗位和兼职岗位信息员工数量>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年9月11日-上午9:40:24
     */
    public Integer getStaffCountByWork(Long workId, Long cid);


    /**
     * @param workId
     * @param cid
     * @return
     * @Comments: <根据岗位获取当前的岗位和兼职岗位信息女员工数量>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年9月11日-上午9:42:24
     */
    public Integer getFemaleStaffCountByWork(Long workId, Long cid);


    /**
     * @param cid
     * @param isThirdParty 是否为劳务外派 如果参数为null，为当前企业全部人员数量
     * @return
     * @Comments: <获取人员数量根据CId>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年9月11日-下午4:16:14
     */
    public Integer getStaffCountByCid(Long cid, Boolean isThirdParty);

    /**
     * @param datas
     * @param loginStaffId
     * @param cid
     * @return 返回已经存在的数据
     * @Comments: <重构人员数据导入功能，入库操作>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年12月26日-下午1:00:50
     */
    public List<StaffInfoExcelImportVo> batchStaffDataStaffInfoExcel(List<StaffInfoExcelImportVo> datas, Long loginStaffId, Long cid);

    /**
     * @param sheet
     * @param loginStaffId
     * @param cid
     * @param isThirdCompany
     * @param outsource      (null:为本企业，1为劳务派遣 2为外包)
     * @return
     * @Comments: <<重构人员数据导入功能，从Excel文件里获取数据>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年12月26日-下午1:07:31
     */
    public StaffInfoNeedImportVo getStaffInfoFromExcel(HSSFSheet sheet, Long loginStaffId, Long cid, Boolean isThirdCompany, Byte outsource);


    /**
     * @param ossfile
     * @param cid
     * @param outsource (null:为本企业，1为劳务派遣 2为外包)
     * @return
     * @throws Exception
     * @Comments: <从人员Excel表中获取数据（不入库，并获取数据校验结果）>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年7月5日-下午1:29:36
     */
    public StaffInfoNeedImportVo getBatchStaffInfoFromExcel(String ossfile, Long cid, Boolean isThirdCompany, Long loginStaffId, Byte outsource);

    /**
     * @param idCard 身份证号
     * @param cid
     * @return
     * @Comments: <根据身份证和cid查staffid:肖奕>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年12月28日-下午3:43:21
     */
    public StaffInfo getStaffInfoIdByIdCardAndCid(String idCard, Long cid);

    /**
     * @param staffBasicIds
     * @return
     * @Comments: <根据人员基础信息表多个ID查询人员信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月2日-下午2:10:35
     */
    public List<StaffInfo> getStaffInfosByStaffBasicIds(List<Long> staffBasicIds, Long cid);

    /**
     * @param idCard
     * @param cid    为0 是所有企业（包括数据无效的和有效的）为null 是当前企业（最新创建的） 具体的cid 查询具体的企业人员信息
     * @return
     * @Comments: <根据身份证号和cid获取人员信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月5日-上午11:42:33
     */
    public List<StaffInfo> getStaffInfoByCardId(String idCard, Long cid);

    /**
     * @param idCard
     * @return
     * @Comments: <根据身份证号获取人员信息>
     * @author wujiacheng
     * @since 2022-10-17
     */
    public List<StaffInfo> getStaffInfoByCardId(String idCard);


    /**
     * @param cid
     * @return
     * @Comments: <根据Cid获取人员表头信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月19日-下午1:11:36
     */
    List<StaffHeaderSet> getStaffHeaderSetsByCid(Long cid, StaffListHeaderEnum[] defaultHeade, Boolean isThirdParty, Long loginStaffId);


    /**
     * @param isThirdParty
     * @param cid
     * @param headerValues
     * @param loginStaffId
     * @Comments: <添加或更新表头(多个)>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月23日-上午9:01:52
     */
    void submitStaffHeaderSets(Boolean isThirdParty, Long cid, String headerValues, Long loginStaffId);

    /**
     * @param query
     * @return
     * @Comments: <体检推荐人员清单查询：严傲>  体检推荐人员清单（在岗期间职业健康检查）
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月25日-上午10:19:01
     */
    List<HealthCheckStaffInfoVo> getRecommendHealthCheckStaffInfosBySearch(HealthCheckStaffInfoQuery query);

    /**
     * @param param
     * @param query
     * @return
     * @Comments: <体检推荐人员清单查询(分页)：严傲> 体检推荐人员清单（在岗期间职业健康检查）
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月25日-上午10:22:20
     */
    PageInfo<HealthCheckStaffInfoVo> getRecommendHealthCheckStaffInfosPageBySearch(JqGridParam param, HealthCheckStaffInfoQuery query);


    /**
     * @param staffInfo
     * @return
     * @Comments: <2.2版本新的添加人员信息功能>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月26日-上午10:37:09
     */
    StaffInfo addNewStaffInfoSubmit(StaffInfo staffInfo);

    /**
     * @param staffInfo
     * @param loginStaffId
     * @Comments: <2.2版本新的编辑人员信息功能>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月29日-下午2:01:40
     */
    void editNewStaffInfoSubmit(StaffInfo staffInfo, Long loginStaffId, Long cid);

    /**
     * @param ossfile
     * @param cid
     * @return 返回检查的数据（所有的来自Excel的数据（含有的数据检查错误的原因））
     * @Comments: <新的人员初始化检查>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月31日-上午10:18:50
     */
    public List<StaffInfoExcelImportVo> getNewStaffBatchInfoFromExcelForInit(String ossfile, Long cid, Long loginStaffId);


    /**
     * @param cacheObj     (来自Excel已存在的数据)
     * @param loginStaffId
     * @return 返回已经更新sheet表里面的数据
     * @Comments: <覆盖更新已存在的人员信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月31日-下午1:52:11
     */
    List<StaffInfoExcelImportVo> coverUpdateStaffDataFromExcel(List<StaffInfoExcelImportVo> cacheObj, Long loginStaffId);


    /**
     * @param workId
     * @param cid
     * @return
     * @Comments: <根据岗位获取当前的岗位和兼职岗位信息员工>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年3月12日-上午9:40:24
     */
    public List<StaffInfo> getHarmStaffIdsByWork(Long workId, Long cid);

    /**
     * @param cid
     * @return
     * @Comments: <根据cid获取接害人信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年3月12日-下午2:05:59
     */
    public List<StaffInfo> getHarmStaffIdsByCid(Long cid);


    StaffInfo addNewStaffInfoSubmitV24(StaffInfo staffInfo);

    /**
     * @param staffInfo
     * @param operationType   值为a，b，c，d
     * @param operationSelect 值为(0根据具体的指示操作，1不操作但要更新其他数据）
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年7月31日-上午9:33:28
     */
    void editNewStaffInfoSubmitV24(StaffInfo staffInfo, Long loginStaffId, Long cid, String operationType, Integer operationSelect);

    /**
     * @param cid
     * @return
     * @Comments: <获取人员数量根据CId>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年9月11日-下午4:16:14
     */
    public Integer getStaffOnWorkCountByCid(Long cid);

    /**
     * @param cid
     * @param isThirdParty
     * @param outsource
     * @return isThirdParty为false， outsource为null返回本企业人员数量
     * isThirdParty为true， outsource为1返回劳动派遣人员数量
     * isThirdParty为true， outsource为2返回外包人员数量
     * isThirdParty为null，outsource为null返回人员数量总数
     * @Comments: <获取人员数量总数，本企业人员数量，劳动派遣人员数量，外包人员数量根据CId>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年8月14日-下午4:11:11
     */
    public Integer getStaffCountByCidAndIsThirdPartyAndOutsource(Long cid, Boolean isThirdParty, Byte outsource);


    public Boolean importStaffExcelFormatIsRight(String ossfile, Boolean isThirdParty, Byte outsource);

    /**
     * @param staffId
     * @return 返回人员名字包含删除信息
     */
    String getStaffNameIncludeDelStatusByStaffId(Long staffId);

    /**
     * @param staffId
     * @return 返回人员名字和工号 包含删除信息
     */
    String getStaffNameAndWorkNoAndIncludeDelStatusByStaffId(Long staffId);

    /**
     * @param staffId
     * @return 返回人员名字包含删除信息(包含部门)
     */
    String getStaffNameIncludeDelStatusAndDepByStaffId(Long staffId);


    /**
     * @param staffId
     * @return 根据staffID获取当前岗位名称
     */
    String getStaffCurrentWorkNameByStaffId(Long staffId);


    /**
     * @param staffId
     * @return 根据staffID获取部门名称
     */
    String getStaffOrgNameByStaffId(Long staffId);


    /**
     * @param staffId
     * @param year
     * @return 获取历史人员姓名
     */
    String getHistroyRealNameByIdAndYear(Long staffId, Date year);


    /**
     * @param staffId
     * @param year
     * @return 获取历史人员基础信息
     */
    StaffBasicInfo getHistroyStaffBasicInfoByIdAndYear(Long staffId, Date year);


    /**
     * @param query
     * @return
     * @Comments: <体检推荐人员清单查询：严傲>  体检推荐人员清单（上岗前职业健康检查）
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月22日-上午10:19:01
     */
    List<HealthCheckStaffInfoVo> getBeforeWorkRecommendHealthCheckStaffInfosBySearch(HealthCheckStaffInfoQuery query);

    /**
     * @param param
     * @param query
     * @return
     * @Comments: <体检推荐人员清单查询(分页)：严傲> 体检推荐人员清单（上岗前职业健康检查）
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年11月22日-上午10:22:20
     */
    PageInfo<HealthCheckStaffInfoVo> getBeforeWorkRecommendHealthCheckStaffInfosPageBySearch(JqGridParam param, HealthCheckStaffInfoQuery query);


    /**
     * @param query
     * @return
     * @Comments: <体检推荐人员清单查询：严傲>  体检推荐人员清单（离岗时职业健康检查）
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月22日-上午10:19:01
     */
    List<HealthCheckStaffInfoVo> getAfterWorkRecommendHealthCheckStaffInfosBySearch(HealthCheckStaffInfoQuery query);

    /**
     * @param param
     * @param query
     * @return
     * @Comments: <体检推荐人员清单查询(分页)：严傲> 体检推荐人员清单（离岗时职业健康检查）
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年11月22日-上午10:22:20
     */
    PageInfo<HealthCheckStaffInfoVo> getAfterWorkWorkRecommendHealthCheckStaffInfosPageBySearch(JqGridParam param, HealthCheckStaffInfoQuery query);


    List<StaffInfo> getHarmStaffIdsByCidAndStatus(Long cid, StaffWorkStatusEnum status);

    /*
     * @Description:获取在线培训推荐人员列表
     * @Author: XiaoYi(肖奕)
     * @Date: 2021/1/28 9:43
     * @param: [query]
     * @return: java.util.List<cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoVo>
     **/
    List<HarmWorkStaffInfoVo> getRecommendTrainStaffInfosBySearch(HarmWorkStaffInfoQuery query);

    PageInfo<HarmWorkStaffInfoVo> getRecommendTrainStaffInfoPageBySearch(JqGridParam param, HarmWorkStaffInfoQuery query);

    /*
     * @Description:获取不在档案里的接害人员列表
     * @Author: XiaoYi(肖奕)
     * @Date: 2021/5/8 14:36
     * @param: [cid, archiveId]
     * @return: java.util.List<cn.smarthse.modules.health.entity.base.staff.vo.HarmWorkStaffInfoVo>
     **/
    List<HarmWorkStaffInfoVo> getHarmWorkStaffInfosNotInArchive(Long cid);

    /**
     * @param query
     * @return 接触职业病危害因素人员清单
     */
    List<HarmWorkStaffInfoVo> getHarmWorkStaffInfosBySearch(HarmWorkStaffInfoQuery query);


    Integer getHistoryBasicStaffCountByWork(Long workId, Long cid, Date date);


    Integer getHistoryBasicFemaleStaffCountByWork(Long workId, Long cid, Date date);


    /**
     * @param workId
     * @param cid
     * @return
     * @Comments: <包含休假(接触的危害因素人数)>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2019年4月17日-上午8:53:49
     */
    Integer getStaffCountHarmsByWork(Long workId, Long cid);


    /**
     * @param staffId
     * @return null 人员为空，0 部门为空 1 部门已删除 2 正常数据
     * @Comments: <根据人员staffId判断部门是否为空>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2019年10月25日-上午10:55:41
     */
    Byte getOrgStatusByStaffId(Long staffId);


    StaffInfo getStaffInfoByWorkNo(String workNo, Long cid);


    /**
     * @param cacheObj
     * @param loginStaffId
     * @return
     * @Comments: <V210版覆盖更新>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2019年12月13日-下午2:54:35
     */
    List<StaffInfoExcelImportVo> coverUpdateStaffDataFromExcelV210(List<StaffInfoExcelImportVo> cacheObj, Long loginStaffId);


    void addNotExistStaffs(List<StaffBasicVo> notExistStaffList);

    void updateStaffNameByIdCardAndCid(Long cid, String idCard, String staffName);

    /**
     * 根据组织id获取人员，过滤离职人员
     *
     * @param cid
     * @param orgId
     * @param searchKey
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi（肖奕)
     * @since 2020年7月21日-上午9:21:27
     */
    List<StaffInfo> getStaffInfosByOrgId(Long cid, Long orgId, String searchKey);

    /**
     * @param staffId
     * @return
     * @Comments: <优化版根据人员id查询人员姓名包括组织>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2020年5月14日-上午11:55:33
     */
    String getFullStaffRealNameAndOrgName(Long staffId);

    /**
     * 查询所有
     *
     * @param cid
     * @return
     */
    List<StaffInfo> getAllByCid(Long cid);


    StaffBasicVo getStaffBasicVoByIdCardNotSelfId(String idCard, Long id, Long cid);


    /**
     * @param staffInfo
     * @return
     * @Comments: <添加来自第三方的人员>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since Sep 7, 2020-4:14:09 PM
     */
    StaffBasicVo addStaffInfoFromOrg(StaffInfo staffInfo);

    /**
     * 多个企业人员导入检查
     *
     * @param ossfile
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi（肖奕)
     * @since 2020年9月1日-上午10:52:17
     */
    public List<StaffInfoExcelImportVo> getStaffBatchInfoFromExcelWithMoreCom(String ossfile);

    public StaffBasicVo getStaffBasicVoFromOrgById(Long id);

    public void updateRealNameByStaffId(String realName, Long staffId);

    void updateMobileByStaffId(String mobile, Long staffId);

    /*
     * @Description: 获取企业离职人员id
     * @Author: XiaoYi(肖奕)
     * @Date: 2021/2/1 10:06
     * @param: [cid]
     * @return: java.util.List<java.lang.Long>
     **/
    public List<Long> getQuitStaffIdsByCid(Long cid);

    /*
     * @Description:根据姓名和身份证查询人员
     * @Author: XiaoYi(肖奕)
     * @Date: 2021/5/10 17:49
     * @param: [name, idCard, cid]
     * @return: cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo
     **/
    public StaffBasicVo getStaffBasicInfoByNameAndIdcard(String name, String idCard, Long cid);

    /*
     * @Description:新增人员
     * @Author: XiaoYi(肖奕)
     * @Date: 2021/5/10 17:50
     * @param: [name, idCard, cid, mobile]
     * @return: cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo
     **/
    public StaffBasicVo addStaffInfoFromTrainPro(String name, String idCard, Long cid, String mobile);

    /**
     * 离岗且离岗日期往前推x天内没有体检记录的staffId
     *
     * @param cid  企业id
     * @param days 天数
     * @return
     */
    List<Long> getStaffIdLeaveAndNoCheck(Long cid, int days);

    HudongSysStaffInfoVo addHuadongStaffInfo(String realName, String workNo, String idCard, Long loginStaffId, Long cid);

    void updateHuadongStaffInfo(Long staffId, String workNo, String idCard, Long loginStaffId, Long cid);


    List<StaffInfoArchiveVo> getStaffInfoArchiveVoByStaffIds(Integer year, Long cid);

    /**
     * @ Description: <体检上报调用，将对应人员修改为可用>
     * @ Author XiaoYi
     * @ Date  2022/7/26  16:48
     * @ param
     * @ return
     **/
    void updataStaffAddFromByCheckId(Long checkId);


    StaffInfo getStaffInfoByIdCardOrTrainUserId(Long cid,String staffName,String idCard,Long trainUserId);

    StaffInfo getStaffInfoByCidAndTrainUserId(Long cid, Long trainUserId);

    List<StaffInfo> updateStaffNameAndIdCardByTrainUserId(Long trainUserId, String idCard, String staffName);

    List<StaffInfo> getListByTrainUserId(Long trainUserId);

    void updateStaffNameAndIdCard(StaffInfo staffInfo);

    StaffInfo getStaffInfoByStaffBasicId(Long staffBasicId, Long cid);

    StaffDocInfoVo getStaffDocInfoVoByStaffIdNew(Long staffId, Long cid);

    List<StaffDocInfoVo> getStaffDocInfoVoByStaffIdNewList(List<Long> staffIdList, Long cid);

    Map<Long, Map<Long,StaffDocInfoVo>> getStaffDocInfoVoMap(Map<Long,List<Long>> cidAndStaffIdListMap);

    /**
     * 根据cid查询人员删除记录
     *
     * @param cid
     * @param page
     * @return
     */
    PageInfo<StaffInfo> getOperateRecords(Long cid, JqGridParam page);

    /**
     * 设置体检人员的岗位状态
     */
    void setPhcPhysicalCheckStaffWorkStatus(List<Long> cids);


    public List<StaffInfo> collectStaffInfoWorkNum(List<Long> cidList, Boolean isThirdParty, Integer workStatus);
    /**
     * 获取人员列表相关数量
     *
     * @param cidList
     * @param param
     * @return {@code Map<Long, Integer> }
     * @author zhangxu
     * @date 2024-04-24
     */
    List<StaffInfo> getStaffInfoWorkNum(List<Long> cidList, Map<String,Object> param);

    List<StaffInfo> getStaffInfoIdList(List<Long> cidList, Map<String, Object> param);

    /**
     * 查询员工需要做什么体检，是否 完成体检
     * @param cids
     * @return
     */
    List<StaffPhySicalCheckModel> queryPhysicalStaffList(List<Long> cids);

    /**
     * 查询没有岗位状态的员工数量
     * @param cids
     * @return
     */
    Map<Long, Integer> countNoWorkStatusNum(List<Long> cids);

    /**
     * 合并重复人员数据
     */
    void mergeStaffInfo(Long cid);

    /**
     * 变更为外来接害人员
     * @param vo
     */
    void changeToThirdCompanyPerson(BatchStafffWorkVo vo);


    void changeThird2SelfPerson(BatchStafffWorkVo vo);

    /**
     * 获取企业中个人档案完成的人员
     *
     * @param cid
     * @param staffIds
     * @return
     */
    List<Long> getStaffIdWithArchive(Long cid, List<Long> staffIds);

    /**
     * 根据人员id查询劳动者培训统计数据
     * @param staffId
     * @return
     */
    ComplianceStaffInfoVo getStaffTrainByStaffId(Long staffId);

    /**
     * 保存人员变更记录
     *
     * @param staffId
     * @param cid
     * @param oldCurrentStaffWorkRole
     * @param currentStaffWorkRole
     * @param oldStaffBasicWork
     * @param staffBasicWork
     * @param oldJobName
     * @param newJobName
     * @param loginStaffId
     * @return
     */
    List<StaffFieldChangeLog> addStaffChangeLogList(Long staffId, Long cid, StaffWorkRole oldCurrentStaffWorkRole, StaffWorkRole currentStaffWorkRole, StaffBasicWork oldStaffBasicWork, StaffBasicWork staffBasicWork, String oldJobName, String newJobName, Long loginStaffId);

    /**
     * 设置为 未入职
     *
     * @param id
     * @param staffId
     * @param cid
     * @param oldWorkStatus
     * @param userId
     */
    void setWorkStatus(Long id, Long staffId, Long cid, Byte oldWorkStatus, Long userId);

    void reloadCheckData(List<StaffPhySicalCheckModel> allList);

    void cleanTable(List<Long> cidList);

    void reloadNewCheckData(List<StaffPhySicalCheckModel> allList);

    void cleanNewTable(List<Long> cidList);

    /**
     * 补全接害人员信息
     *  1、staffBasicWork
     * @param cid
     */
    void improveStaffInfo(Long cid);

    /**
     * 根据人员id获取人员相关信息
     * @param staffInfoIdList
     * @return
     */
    List<StaffInfoExcelImportVo> getStaffInfoByIdList(List<Long> staffInfoIdList);

    /**
     * 合规企业-接害人员异常清单
     * @return
     */
    List<StaffAbnormalInfo> complianceStaffAbnormalList(Long cid,String keyword);

    /**
     * 合规企业-接害人员异常清单 分页
     * @param cid
     * @return
     */
    PageInfo<StaffAbnormalInfo> complianceStaffAbnormalListPage(JqGridParam param,Long cid,String keyword);

    /**
     * 补全岗位时间信息
     *  1、首次上岗时间
     *  2、本岗位上岗时间
     */
    void improveWorkTime(List<Long> cidList);

    /**
     * 补全合规企业中人员岗位时间信息
     * 1、首次上岗时间
     * 2、本次上岗时间
     * @param cidList
     */
    void improveWorkTimeByCompliance(List<Long> cidList);

    void staticsStaffLatelyCheckTime(Long cid);
    void staticsStaffLatelyCheckTimeBatch(List<Long> cidList);


    List<StaffInfo> getByIdcardList(Long cid, List<String> idcardList);

    /**
     * 体检机构添加接害人员
     * @param insertList
     */
    void addOrgCheckStaffInfo(List<StaffInfo> insertList,Long operatorId);

    List<Long> getStaffIdByStaffNameAndCid(String staffName, Long cid);

    /**
     * 根据企业id获取外部单位名称
     * @param cid
     * @return
     */
    List<String> getOtherCompany(Long cid);
}
