package cn.smarthse.modules.health.service.base.staff;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 《xxxService》
 *
 * @author binxu(徐斌) [784514607@qq.com]
 * @Project: GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @since 2017-06-13 08:26
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IStaffBasicWorkService extends IBaseService<StaffBasicWork> {

    /**
     * @param staffId
     * @return
     * @Comments: <根据人员ID获取人员基本岗位信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年6月20日-下午6:29:02
     */
    StaffBasicWork getStaffBasicWorkByStaffId(Long staffId);

    /**
     * 根据人员ID获取人员基本岗位信息 包含删除信息
     *
     * @param staffId
     * @return
     */
    StaffBasicWork getStaffBasicWorkIncludeDelStatusByStaffId(Long staffId);

    /**
     * @param orgId
     * @return
     * @Comments: <根据组织ID获取岗位基本信息集合>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年6月21日-下午5:09:20
     */
    List<StaffBasicWork> getStaffBasicWorksByOrgId(Long orgId);

    /**
     * @param orgId
     * @return
     * @Comments: <根据组织ID获取人员基础信息和当前岗位信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年6月27日-下午12:20:11
     */
    List<StaffBasicWork> getStaffBasicWorkDetailByOrgId(Long orgId);

    /**
     * @param orgId
     * @param pageNum
     * @param pageSize
     * @return
     * @Comments: <根据组织Id获取人员基本信息和岗位相关信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年6月27日-下午12:46:52
     */
    public PageInfo<StaffBasicWork> getStaffBasicWorkDetailByOrgId(Long orgId, Integer pageNum, Integer pageSize);

    /**
     * @param staffBasicWork
     * @param loginStaffId
     * @param cid
     * @Comments: <提交人员岗位信息数据>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年6月28日-下午6:03:04
     */
    void editStaffBasicWorkSubmit(StaffBasicWork staffBasicWork, Long loginStaffId, Long cid);


    /**
     * @param cid
     * @param searchKey
     * @return
     * @Comments: <根据人员姓名进行模糊搜索人员岗位信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年12月14日-上午11:10:29
     */
    List<StaffBasicWork> getStaffBasicWorksByRealName(Long cid, String searchKey);

    /**
     * @param orgId
     * @param searchKey
     * @return
     * @Comments: <根据人员姓名进行模糊搜索人员岗位信息>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年12月14日-下午12:43:02
     */
    List<StaffBasicWork> getStaffBasicWorksByOrgIdAndSearchKey(Long cid, Long orgId, String searchKey);

    StaffBasicWork getStaffBasicWorkIncludeNoIsValidByStaffId(Long staffId);

    /**
     * @param staffBasicWork
     * @param loginStaffId
     * @param cid
     * @Comments: <提交人员岗位信息数据2.2版本>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年6月28日-下午6:03:04
     */
    void editNewStaffBasicWorkSubmit(StaffBasicWork staffBasicWork, Long loginStaffId, Long cid);

    void upDateStaffBasicWorkByIdForOverUpdate(StaffBasicWork staffBasicWork, Long loginStaffId);

    /**
     * @param staffId
     * @return 包含无效数据
     */
    StaffBasicWork getStaffBasicWorkIncludeDeleteByStaffId(Long staffId);

    StaffBasicVo getByWorkNo(String workNo, Long cid);

    StaffBasicWork getStaffBasicWorkByWorkNo(String workNo, Long cid);

    /**
     * @param orgId
     * @return
     * @Comments: <根据部门获取人员数量>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2019年12月20日-下午3:34:20
     */
    Integer getSaffCountByOrgId(Long orgId);

    /**
     * @param cid
     * @param orgId
     * @param searchKey
     * @return
     * @Comments: <选人插件-根据部门获取人员，过滤离职人员>
     * @author yanao
     * @since 2020年2月21日- 10:35
     */
    List<StaffInfo> getStaffInfosByOrgIdAndSearch(Long cid, String searchKey, Long workId, List<Long> orgIds);

    /**
     * 选人插件-根据部门获取人员 包括离岗人员、外来人员
     *
     * @param cid
     * @param searchKey
     * @param workId
     * @param orgIds
     * @return
     */
    List<StaffInfo> getStaffInfosByOrgIdAndSearch2(Long cid, String searchKey, Long workId, List<Long> orgIds);

    /**
     * 查询所有
     *
     * @param cid
     * @return
     */
    List<StaffBasicWork> getAllByCid(Long cid);

    void updateByStaffId(StaffBasicWork work, Long staffId, Long loginStaffId, Long cid);
}
