/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.staff;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.importstaff.StaffInfoExcelImportVo;

import java.util.List;


/**
 * 
 * 《xxxService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author binxu(徐斌) [784514607@qq.com]
 * @since 2017-06-13 08:26
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IStaffBasicInfoService extends IBaseService<StaffBasicInfo>{

	/**
	 * 
	 * @Comments:  <根据IDCard获取人员基本信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年7月4日-下午4:10:48
	 * @param idCard
	 * @return
	 */
	StaffBasicInfo getStaffBasicInfoByIdCard(String idCard,Long basicId,Long cid);


	/**
	 * 根据ids查询用户名
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-8-下午5:56:57
	 * @param ids
	 * @return
	 */
	String getUserName(String ids);
	
	List<StaffBasicInfo> getStaffBasicInfosByCardId(String cardId);

	 /**
	  * 根据身份证查询
	  * @param cardIds
	  * @return
	  */
	List<StaffBasicInfo> getStaffBasicInfosByCardIds(List<String> cardIds);

    /**
     * 
     * @Comments:  《根据身份证号，企业ID查询人员基础信息》
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2018年1月2日-下午1:42:15
     * @param cardId
     * @param cid
     * @return
     */
    List<StaffBasicInfo> getStaffBasicInfosByCardIdAndCid(String cardId,Long cid);


	/**
	 * 
	 * @Comments:  <根据idCard获取最新的人员基础信息>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年1月5日-上午11:55:50
	 * @param idCard
	 * @return
	 */
	StaffBasicInfo getFirstStaffBasicInfoByIdCard(String idCard);


	/**
	 * 
	 * @Comments:  <根据身份证号获取所有人员基础信息（包括有效的和无效的）>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2018年1月5日-下午12:11:35
	 * @param idCard
	 * @return
	 */
	List<StaffBasicInfo> getAllStaffBasicInfoByIdCard(String idCard);
	
	void upDateStaffBasicInfoByIdForOverUpdate(StaffBasicInfo staffBasicInfo,Long loginStaffId);

     void updateStaffNameByIdCardAndCid(Long cid, String idCard, String staffName);

	 /**
	  * 获取所有
	  * @param cid
	  * @return
	  */
	 List<StaffBasicInfo> getAllByCid(Long cid);

	 /**
	  * 获取所有有效的人员基础信息（按照名称排序）
	  * @param idCard
	  * @return
	  */
	 List<StaffBasicInfo> getAllBasicInfoByIdCard(String idCard);


    /**
     * 获取当前岗位名称，并设置基础信息中岗位字段
     * @return
     */
    void setStaffJobName();

    /**
     * 根据身份证查询系统中人员相关id
     * @param cid
     * @param idCardList
     * @return
     */
    List<StaffInfoExcelImportVo> getByCidAndIdCard(Long cid, List<String> idCardList);
 }
