package cn.smarthse.modules.health.service.base.staff;

import java.util.List;
import java.util.Map;

import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffShowInfo;

/**
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <华东人员导入专用接口>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author BinXu(徐斌) [784514607@qq.com]
 * @since 2019年11月8日-上午9:05:59
 */
public interface IHuaDongStaffImportService{
	
	/**
	 * 
	 * @Comments:  <添加华东人员>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年11月8日-上午9:11:54
	 * @param staffInfo
	 * @return
	 */
	public StaffInfo addHuaDongStaff(StaffInfo staffInfo);
	
	/**
	 * 
	 * @Comments:  <根据人员id获取华东人员>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年11月8日-上午9:13:05
	 * @param id
	 * @return
	 */
	public StaffInfo getHuaDongStaffById(Long id);
	
	/**
	 * 
	 * @Comments:  <更新华东人员>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2019年11月8日-上午9:13:50
	 * @param staffInfo
	 * @return
	 */
	public  StaffInfo updateHuaDongStaff(StaffInfo staffInfo);
	
	/**
     * 
     * @Comments:  <根据工号获取人员信息(华东人员同步)>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2019年11月14日-上午10:23:22
     * @param workNo
     * @return
     */
    public StaffInfo getStaffInfoByWorkNo(String workNo,Long cid);
    
    
    /**
     * 
     * @Comments:  <通过部门编码获取组织>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2020年1月9日-下午5:19:22
     * @param code
     * @return
     */
    public CompanyOrganization getCompanyOrganizationByCode(Long cid,String code);
    
    /**
     * 
     * @Comments:  <添加部门>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2020年1月9日-下午5:19:52
     * @param name
     * @param code
     * @return
     */
    public CompanyOrganization addCompanyOrganizationByCode(CompanyOrganization org);

	/**
	 * 
	 * @Comments:  <更新华东部门>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2020年1月10日-下午1:11:04
	 * @param comOrg
	 */
	public void upateCompanyOrganization(CompanyOrganization comOrg);

	List<CompanyOrganization> getAllCompanyOrganizations(Long cid);

    List<CompanyOrganization> getAllCompanyOrganizationsHasCode(Long cid);

    void upateCompanyOrganizationIncludeNull(CompanyOrganization co);

    List<StaffShowInfo>  getAllStaffInfoNotIncludeNullWorkNo(Long cid);

    void updateCurrentStaffWorkRoleNotWorkedByStaffId(Long staffId);
}
