package cn.smarthse.modules.health.service.base.selfjudge;

import cn.smarthse.common.framework.database.mybatis.HSEMapper;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.selfjudge.SelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfInspectionRiskAssessmentReportForm;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfInspectionRiskAssessmentReportV314Vo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfInspectionRiskAssessmentReportVo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfjudgeReportSearchVo;
import cn.smarthse.modules.health.vo.base.company.gradev3.SelfReportCollectVo;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskExposeEvaluateVo;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;

/**
 *
 */
public interface ISelfInspectionRiskAssessmentReportInfoService extends IBaseService<SelfInspectionRiskAssessmentReportInfo> {
    PageInfo<SelfInspectionRiskAssessmentReportVo> listPageData(JqGridParam jqGridParam);

    PageInfo<SelfInspectionRiskAssessmentReportVo> listPageDataBySearch(JqGridParam jqGridParam, SelfjudgeReportSearchVo vo);

    SelfInspectionRiskAssessmentReportVo  getVoById(Long id);

    void saveReportSubmit(SelfInspectionRiskAssessmentReportForm form,Long loginStaffId,Long cid);

    void saveSelfReportSubmit(SelfInspectionRiskAssessmentReportForm form,Long loginStaffId,Long cid);

    void deleteReport(Long id, Long loginStaffId);

    void deleteSelfReport(Long id, Long loginStaffId);

    SelfInspectionRiskAssessmentReportInfo addNotIsValid(Long cid, Long loginStaffId);

    void giveUpJudge(Long reportInfoId, Long loginStaffId);

    List<SelfInspectionRiskAssessmentReportVo> listDataEveryCidLatestByDateRange( Date beginDate,  Date endDate);
    
    /* 
    *  cid为空查所有
    **/
    List<SelfInspectionRiskAssessmentReportInfo> listDataV314EveryCidLatestForSuperviseByDateRange( Date beginDate,  Date endDate,List<Long> cids);

    List<SelfInspectionRiskAssessmentReportVo> listAllData();

    PageInfo<SelfInspectionRiskAssessmentReportV314Vo> listPageDataV314(JqGridParam jqGridParam);

    SelfInspectionRiskAssessmentReportInfo addThisYearSelfInspectionRiskAssessmentReport(Long loginStaffCompanyId, Long loginStaffId);

    public PageInfo<RiskExposeEvaluateVo> pageRiskExposeEvaluateVo(Long cid);
    SelfInspectionRiskAssessmentReportV314Vo getV314VoById(Long id);

    SelfInspectionRiskAssessmentReportV314Vo  getLatestV314VoByCid(Long cid);

    List<SelfReportCollectVo>  getSelfReportInfoCollectVosByRangTime(Date beginDate,  Date endDate);
    SelfReportCollectVo  getSelfReportInfoCollectVosByRangTimeAndCid(Date beginDate,  Date endDate,Long cid);

    List<SelfReportCollectVo>  getSelfReportInfoCollectVoListByRangTimeAndCid(Date beginDate,  Date endDate,Long cid);
    /* 
    * @Comments:  <监管统计分类自查接口>
    * @author BinXu(徐斌) [784514607@qq.com]
    * @since 下午3:26 2022/6/17
    **/
    List<SelfReportCollectVo>  getSelfReportInfoCollectVoListHasJudgeByRangTimeAndCid(Date beginDate,  Date endDate,List<Long> cids);

    void synCompanyReportInfo(SelfInspectionRiskAssessmentReportInfo info);

    SelfInspectionRiskAssessmentReportInfo saveSelfReportChangeReason(SelfInspectionRiskAssessmentReportInfo reportInfo,Long cid, Long loginStaffId);
    /* 
    * @Comments:  <监管端审核使用>
    * @author BinXu(徐斌) [784514607@qq.com]
    * @since 上午11:25 2022/3/29
    * @param reportInfo.status 3:退回  4:审核完成
    *  0 更新失败 1 更新成功
    **/
    int examineAndVerifySelfReportById(SelfInspectionRiskAssessmentReportInfo reportInfo, Long loginUserId);

    List<SelfInspectionRiskAssessmentReportInfo> getAllHasExposeIdAndSelfIdByCid(Long loginStaffCompanyId);

    /* 
    * @Comments:获取有职业卫生管理状况发生重大变化的变更报告
    * @param cid
    * @param selfId 自查id
    */
    List<SelfInspectionRiskAssessmentReportInfo> getAllHasExposeIdAndChangeTypeByCidAndSelfId(Long cid,Long selfId);

    List<SelfInspectionRiskAssessmentReportInfo> getAllHasExposeIdByCidAndSelfId(Long cid,Long selfId);

    /**
     * 临时使用一次（需要把risk_expose_evaluate表迁移只test2）
     * zhangxu 2023-1-12
     * @return
     */
    List<SelfInspectionRiskAssessmentReportV314Vo> getAllHistoryReportInfo();


    /**
     * 放射企业合并暴露风险数据
     *
     * @param searchCid 搜索cid
     * @return {@link RiskExposeEvaluate}
     */
    RiskExposeEvaluate mergerAdiationAndWandaRisk(Long searchCid);


    List<RiskExposeEvaluate> listLastRiskExposeEvaluate(List<Long> cids);

}