package cn.smarthse.modules.health.service.base.selfjudge;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeRecord;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeV308;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.SelfjudgeSearchVo;
import com.github.pagehelper.PageInfo;
import tk.mybatis.mapper.entity.Example;

import javax.cn.smarthse.modules.health.exception.BusinessException;
import java.util.List;

/**
 * @Project
 * @Module 自我评定
 * @JDK_Vserion 1.8
 */
public interface IOccupationalSelfJudgeV308Service extends IBaseService<OccupationalSelfJudgeV308> {


    OccupationalSelfJudgeV308 getLastJudge(Long loginStaffId, Long loginStaffCompanyId);

    OccupationalSelfJudgeV308 getThirdOrgLastJudge(Long loginStaffCompanyId);

    OccupationalSelfJudgeV308 create(Long loginStaffId, Long loginStaffCompanyId);

    OccupationalSelfJudgeV308 createReportSelfJudge(Long loginStaffId, Long loginStaffCompanyId,Long judgeInfoId);

    OccupationalSelfJudgeV308 completeSubmit(OccupationalSelfJudgeV308 record,Long loginStaffId ,Long loginStaffCompanyId);

    int getHistoryCount(Long loginStaffId, Long loginStaffCompanyId);

    void giveUp(Long loginStaffId, Long loginStaffCompanyId);

    PageInfo<OccupationalSelfJudgeV308> getHistoryList(int page, int rows, Long loginStaffId, Long loginStaffCompanyId);

    PageInfo<OccupationalSelfJudgeV308> getSelfjudgeList(JqGridParam jqGridParam, SelfjudgeSearchVo vo);

    OccupationalSelfJudgeV308 getOccupationalSelfJudgeV308ById(Long recordId);

    void saveOrgSelfJudge(OccupationalSelfJudgeV308 selfJudgeV308);

    List<OccupationalSelfJudgeV308> importOccupationalSelfJudgeV308Datas(List<OccupationalSelfJudgeV308> records);

    List<OccupationalSelfJudgeV308> selectByExample(Example example);

    OccupationalSelfJudgeV308 getCompleteLastJudge(Long loginStaffCompanyId);
}
