package cn.smarthse.modules.health.service.base.selfjudge;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeSkip;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author 邓力宾
 * @Email dlb@smarthse.cn
 * @Desc 自我评定 跳过业务接口
 * @since 19-6-6 上午11:55
 */
public interface IOccupationalSelfJudgeSkipService extends IBaseService<OccupationalSelfJudgeSkip> {
    /**
     * 添加跳过记录
     * @param loginStaffId 员工id
     * @param cid 企业id
     * @return
     */
    OccupationalSelfJudgeSkip insert(Long loginStaffId, Long cid);

    /**
     * 查询跳过记录
     * @param staffId 人员id 可为null
     * @param cid 企业id 不能为null
     * @param pageNum
     * @param pageSize
     * @return
     */
    PageInfo<OccupationalSelfJudgeSkip> query(Long staffId, Long cid, int pageNum, int pageSize);
    /**
     * 查询跳过记录
     * @param staffId 人员id 可为null
     * @param cid 企业id 不能为null
     * @return
     */
    List<OccupationalSelfJudgeSkip> query(Long staffId, Long cid);


}
