package cn.smarthse.modules.health.service.base.selfjudge;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeRecord;
import cn.smarthse.modules.health.entity.base.selfjudge.OccupationalSelfJudgeV308;
import com.github.pagehelper.PageInfo;

import javax.cn.smarthse.modules.health.exception.BusinessException;

/**
 * @Project
 * @Module 自我评定
 * @JDK_Vserion 1.8
 * @Author 邓力宾
 * @Email dlb@smarthse.cn
 * @Desc 自我评定业务接口
 * @since 19-6-3 下午1:24
 */
public interface IOccupationalSelfJudgeRecordService extends IBaseService<OccupationalSelfJudgeRecord> {




    /**
     * 创建一条评定
     * @param loginStaffId 员工id
     * @param cid 企业id
     * @return
     */
    OccupationalSelfJudgeRecord create(Long loginStaffId, Long cid);

    /**
     * 最后一次的评定(包括进行中的)
     * @param staffId 员工id
     * @param cid 企业id
     * @return
     */
    OccupationalSelfJudgeRecord getLastJudge(Long staffId, Long cid);

    /**
     * 放弃评定
     * @param staffId
     * @param cid
     */
    void giveUp(Long staffId, Long cid);


    /**
     * 评定历史记录
     * @param pageNum 页码
     * @param pageSize 每页大小
     * @param staffId 员工id
     * @param cid 企业id
     * @return
     */
     PageInfo<OccupationalSelfJudgeRecord> getHistoryList(int pageNum, int pageSize, Long staffId, Long cid);

    /**
     * 评定完成,提交
     * @param recordId 评定记录id
     * @param loginStaffId 员工id
     * @param cid 企业id
     * @return
     */
     OccupationalSelfJudgeRecord completeSubmit(Long recordId, Long loginStaffId, Long cid) throws BusinessException, IllegalAccessException;

    /**
     * 一般项合格数量
     * @param record
     * @return
     */
     Integer getGeneralTermNum(OccupationalSelfJudgeRecord record);



    /**
     * 否决项合格数量
     * @param record
     */

    Integer getVetoTermNum(OccupationalSelfJudgeRecord record);

    /**
     * 查询最后(新)一次评定(评定)
     * @param cid 企业id
     * @param year 年份
     * @param status 状态 1:评定中 2:完成'
     * @return
     */
    OccupationalSelfJudgeRecord getLastJudge(Long cid, Integer year, Integer status);

    OccupationalSelfJudgeV308 getLastJudgeV308(Long cid, Integer year, Integer status);

}
