package cn.smarthse.modules.health.service.base.selfjudge;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.*;
import cn.smarthse.modules.health.vo.base.company.gradev3.SelfReportCollectVo;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 *
 */
public interface ICompanyHsePreventionControlSelfJudgeService extends IBaseService<CompanyHsePreventionControlSelfJudge> {
    PageInfo<CompanyHsePreventionControlSelfJudgeVo> listPageData(JqGridParam jqGridParam);

    CompanyHsePreventionControlSelfJudgeVo getVoById(Long id);

    int savePreventionControlSelfJudgeSubmit(CompanyHsePreventionControlSelfJudgeForm form, Long loginStaffId, Long loginStaffCompanyId);

    void deleteSelfJudge(Long id, Long loginStaffId);

    CompanyHsePreventionControlSelfJudge  getLatestSelfJudgeByDateRange(Long cid,Date begin,Date end);

    CompanyHsePreventionControlSelfJudge addNotIsValid(CompanyHsePreventionControlSelfJudge selfJudge, Long loginStaffId, Long loginStaffCompanyId);

    int saveTermSituationsSubmit(CompanyHsePreventionControlSelfJudgeForm form, Long loginStaffId, Long loginStaffCompanyId);

    CompanyRiskJudgeV313Vo getLastCompanyRiskJudgeV313VoByCid(Long cid);

    CompanyHsePreventionControlSelfJudge getLatestEntityByCid(Long cid);

    PageInfo<CompanyHsePreventionControlSelfJudge> getSelfjudgeListV313(JqGridParam jParam, SelfjudgeSearchVo vo);

    List<CompanyInvestigationAndSelfJudgeStatVo> getStatEveryCidLatestByDateRange(Date beginDate,  Date endDate);

    List<CompanyHsePreventionControlSelfJudge> listDataEveryCidLatestByDateRange(Date beginDate,Date endDate);
    
    /* 
    * cid 为空查所有企业
    **/
    List<CompanyHsePreventionControlSelfJudge> listDataV314EveryCidLatestByDateRange(Date beginDate,Date endDate,Long cid);

    /*
     * cid 为空查所有企业
     **/
    List<CompanyHsePreventionControlSelfJudge> listDataV314EveryCidLatestForSuperviseByDateRange(Date beginDate,Date endDate,List<Long> cids);


    void importCompanyHsePreventionControlSelfJudgeDatas(List<CompanyHsePreventionControlSelfJudge> records);

    void saveOrgSelfJudge(CompanyHsePreventionControlSelfJudge selfJudge);

    CompanyHsePreventionControlSelfJudge addThisYearSelfJudge(Long loginStaffCompanyId, Long loginStaffId);

    CompanyHsePreventionControlSelfJudge getThisYearLatestSelfJudge(Long loginStaffCompanyId, Integer year);


    List<SelfReportCollectVo>  getSelfJudgeCollectVosByRangTime(Date beginDate, Date endDate);
    SelfReportCollectVo  getSelfJudgeCollectVosByRangTimeAndCid(Date beginDate,  Date endDate,Long cid);

    CompanyHsePreventionControlSelfJudge getLatestEntityNoStatusByCid(Long cid);
    /*
    * id 自查id
    **/
    CompanyHsePreventionControlSelfJudgeVo getV314VoById(Long id);

    /*
     * @Comments:  <监管端审核使用>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 上午11:25 2022/3/29
     * @param selfJudge.status 3:退回  4:审核完成
     *  0 更新失败 1 更新成功
     **/
    int examineAndVerifySelfJudgeById(CompanyHsePreventionControlSelfJudge selfJudge, Long loginUserId,String reason,String operater,String companyName);
    /*
    *
    * 添加变更类型的自查
    **/
    CompanyHsePreventionControlSelfJudge addChangeTypeSelfJudge(CompanyHsePreventionControlSelfJudge selfJudge,Long reportId ,Long loginStaffCompanyId, Long loginStaffId);

    Map<Long, CompanyHsePreventionControlSelfJudge> queryByIds(List<Long> selfIds);

    /**
     * 第22项自查表系统判定接口：
     *      如果是审核完成，则需要重新对第22项检查结果进行判定，
     *      如果是不符合，但是企业强行选择符合，则纳入自查结果不可靠企业统计
     */
    void unreliableCompanyJudge(Long cid, Long loginStaffId);

    /**
     * 第22项判定 0-符合；其他-不符合
     * @param cid
     * @return
     */
    int getCountForSettingCheckResult(Long cid);

    String editToBeReviewedInfo();

    /**
     * 判断分数使用，是否是新规则
     * @return
     */
    boolean isNewRule(Date selfTime);


    /**
     * 是否健康企业
     * @param cid
     * @return
     */
    public boolean isBest(Long cid);

    /**
     * 设置/取消健康企业时修改该企业的自查等级
     * 暂时使用best来表示健康/非健康企业
     * @param cids  用逗号隔开
     */
    void checkAndChangeSelfLevel(String cids,Boolean best);

    /**
     * 退回时复制一条数据给企业端修改
     * @param vo
     */
    void copyThisData2Db(CompanyHsePreventionControlSelfJudge selfJudge);

    /**
     * 根据id 获取源数据id（仅限复制的自查数据使用）
     * @return
     */
    Long getSourceDataId(Long id,Long cid);

    Boolean isFinishSelf(Long cid);

    /**
     * 添加退回的数据，用于2022年4月前的退回数据
     * @param loginStaffCompanyId
     */
    void addReturnData(Long loginStaffCompanyId);

    /**
     * 实训基地，重置所有自查
     * @param cid
     */
    void resetSelfJudge(Long cid);
}