/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.occriskfactor;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkDiseaseVo;
import cn.smarthse.modules.health.entity.work.shield.vo.HarmfactorWorkInfo;

import java.util.List;
import java.util.Map;


/**
 * 
 * 《OccupationalRiskFactors》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2017-07-04 06:14
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IOccupationalRiskFactorsService extends IBaseService<OccupationalRiskFactors>{

	/**
	 * 
	 * 
	 * @Comments:  根据对象是否有主键id 判断做更新还是创建操作
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017-07-04 06:14
	 * @param OccupationalRiskFactors
	 * @param loginStaffId
	 * @param cid
	 * @return
	 * @throws Exception
	 */
	public OccupationalRiskFactors saveOrUpdateOccupationalRiskFactors(OccupationalRiskFactors occupationalRiskFactors, Long loginStaffId,Long cid) throws Exception;
	
	
	
	/**
     * 查询危害因素列表
     * @param cid		企业编号（若取NULL，返回系统设置的危害因素）
     * @param keyword	查询关键词
     * @return
     */
    List<OccupationalRiskFactors> selectList(Long cid,String keyword, String harmTypes);
    
    
    /**
     * 
     * @Comments:  <根据paramCode查危害因素数据>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 2017年8月9日-上午10:16:51
     * @param paramCode
     * @return
     */
    OccupationalRiskFactors   getOneOccupationalRiskFactorsByParamCode(String paramCode);

    
    /**
	 * 
	 * @Comments:  <根据类型获取对应的危害因素>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年8月31日-下午4:32:33
	 * @return
	 */
	List<OccupationalRiskFactors>  getOccupationalRiskFactorsListByCid(String type,String searchKey,Long cid);



	/**
	 * 
	 * @Comments:  <根据名字获取>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月18日-上午8:37:10
	 * @param name
	 * @return
	 */
	public OccupationalRiskFactors getOccupationalRiskFactorsByNameCh(String name);



	/**
	 * 
	 * @Comments:  <添加其他危害因素>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月19日-上午9:32:51
	 * @param factors
	 * @param loginStaffId
	 * @param cid
	 * @return
	 */
	public Map<Boolean, OccupationalRiskFactors> addOtherOccupationalRiskFactorsSubmit(OccupationalRiskFactors factors, Long loginStaffId, Long cid);


	public OccupationalRiskFactors addOtherOccupationalRiskFactorsSubmit2(OccupationalRiskFactors factors, Long loginStaffId, Long cid);
	/**
	 * 
	 * @Comments:  <删除危害因素>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月19日-上午9:49:23
	 * @param id
	 */
	public void deleteOtherOccupationalRiskFactorsById(Long id);
	
	
	/**
	 * 根据id查询警示内容
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-22-上午9:38:16
	 * @param id
	 * @return
	 */
	String getWarnings(Long id);
	
	/**
	 * 
	 * @Comments:  <根据名字获取>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2017年9月18日-上午8:37:10
	 * @param name
	 * @return
	 */
	public OccupationalRiskFactors getOccupationalRiskFactorsAutoCompleteByNameCh(String type,String name,Long cid);
	
	/**
	 * 
	 * 
	 * @Comments:  <获取危害因素类型、类型的相关参数>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年5月18日-上午11:13:06
	 * @param param
	 * @return
	 */
	public HarmfactorWorkInfo getHarmInfoById(HarmfactorWorkInfo param);
	
	List<HarmfactorWorkInfo> selectShieldHarmList(Long cid,String keyword);

	/**
	 *@Comments:  <获取危害因素名称、可能产生的职业病>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2019年1月17日-下午4:37:06
	 * @param harmIds
	 * @return
	 */
	List<HarmfactorWorkDiseaseVo> getHarmfactorAndDieaseListByHarmIds(List<Long> harmIds);

	/**
	 * @Comments:  <通过危害因素名称 cid 获取危害因素>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2020/2/28-15:09
	 * @param cid
	 * @param nameCh
	 * @return java.util.List<cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors>
	*/
	public List<OccupationalRiskFactors> getHarmfactorByNameCid(Long cid, String nameCh);


	/**
	 * @Comments:  <导入需求， 解析危害因素名称，  没有的情况下 添加到自定义危害因素>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2020/3/2-13:53
	 * @param harmName
	 * @param cid
	 * @return java.lang.Long
	*/
	public Long parseHarmName(String harmName, Long cid);

	List<OccupationalRiskFactors> getAll();

	List<OccupationalRiskFactors> getByIds(String ids);


	String getHarmNamesByIds(String ids);

	String getIdsByNames(String names);
}
