/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.ms;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.entity.base.ms.MsInfo;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;


/**
 * 
 * 《IMsInfoService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <4.5.2>
 * @Comments:  <管理制度>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-06-08 14:12
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IMsInfoService extends IBaseService<MsInfo>{
    
	//根据cid查询管理制度(带分页)
	PageInfo<MsInfo> getMsInfoListByGridParam(JqGridParam gparam);
	
	//根据cid查询管理制度(不带分页)
	List<MsInfo> getMsInfoList(Long cid);
	
	/**
	 * 档案2接口(传入企业id,返回管理制度list)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  徐颖东 [xyd.900919@qq.com]
	 * @since 2017-8-22-上午10:57:23
	 * @param cid		企业编号
	 * @return	List<MsInfo>(管理制度);
	 */
	List<MsInfo> getMsInfoListByCid(Long cid,Integer year);

	 /**
	  * 省项目3.1.4 档案接口
	  * @param cid
	  * @param year
	  * @return
	  */
	 public List<MsInfo> getMsInfoArchiveListByCid(Long cid, Integer year);

	int getMsInfoCountHasFile(Long cid);

	 /**
	  * 根据cid查询管理制度(带分页，可模糊查询)
	  * @param param
	  * @param keyword
	  * @return
	  */
     PageInfo<MsInfo> getMsInfoListByGridParamAndKeyWord(JqGridParam param, String keyword);


	 public List<MsInfo> getLiteArhiveData(MsInfo msinfo);

	 /**
	  * 已上传文件的管理制度统计
	  * @param cidList
	  * @return
	  */
	 List<MsInfo> getUploadCount(List<Long> cidList);


	/**
	 * 获取该企业制度档案是否完成
	 * @param cid
	 * @param param
	 * @return {@code Map<String, String> }
	 * @author zhangxu
	 * @date 2024-04-28
	 */
	List<ComplianceCompanyItemdata> getInstitutionInfo(Long cid, Map<String, Object> param);
 }
