/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.ms;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.ms.MsEmergencyPlan;


 /**
 * 
 * 《IMsEmergencyPlanService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <4.5.8>
 * @Comments:  <应急预案>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-06-08 14:12
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IMsEmergencyPlanService extends IBaseService<MsEmergencyPlan>{
	
	// 根据cid查询应急预案(带分页)
	PageInfo<MsEmergencyPlan> getMsEmergencyPlanListByGridParam(JqGridParam gparam);

	// 根据cid查询应急预案(不带分页)
	List<MsEmergencyPlan> getMsEmergencyPlanList(Long cid);


	 public List<MsEmergencyPlan> listMsEmergencyPlanList(Long cid);
	
	//新增应急预案
	void addMsEmergencyPlan(Long cid, Long staffid, MsEmergencyPlan msEmergencyPlan);
		
	//编辑应急预案
	void updateMsEmergencyPlan(Long cid, Long staffid, MsEmergencyPlan msEmergencyPlan);
	
	/**
	 * 档案2接口(传入企业id,返回应急预案list)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  徐颖东 [xyd.900919@qq.com]
	 * @since 2017-8-22-上午10:57:23
	 * @param cid		企业编号
	 * @return	List<MsInfo>(应急预案);
	 */
	List<MsEmergencyPlan> getMsEmergencyPlanListByCid(Long cid,Integer year);

	/**
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年11月14日-上午10:32:15
	 * @param msEmergencyPlan
	 * @param staffid
	 * @param cid
	 */
	void deleWithHis(MsEmergencyPlan msEmergencyPlan, Long staffid, Long cid);

	 /**
	  * 根据cid查询应急预案(带分页，可模糊查询)
	  * @param param
	  * @param keyword
	  * @return
	  */
     PageInfo<MsEmergencyPlan> getMsEmergencyPlanListByGridParamAndKeyWord(JqGridParam param, String keyword);
 }
