/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.material;

import java.math.BigDecimal;
import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialUseInfo;


 /**
 * 
 * 《物料管理Service》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author gbx
 * @since 2017-06-08 03:09
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IPmcMaterialUseInfoService extends IBaseService<PmcMaterialUseInfo>{

	
	/**
	 * 获取企业的物料年使用量合计
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年1月9日-上午11:33:31
	 * @param materialId
	 * @return
	 */
	 BigDecimal getUsageTotal(Long materialId);

	PageInfo<PmcMaterialUseInfo> getUseInfoItemList(JqGridParam gparam,Long materialId);
	
	/**
	 * 根据id查询单个
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-6-21-上午9:44:11
	 * @param id
	 * @return
	 */
	PmcMaterialUseInfo getUseInfoById(Long id);
	
	/**
	 * 逻辑删除
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-6-21-上午10:14:32
	 * @param id
	 */
	void del(Long id,Long staffId);
	
	
	/**
	 * 查询使用信息列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-8-上午10:02:00
	 * @param cid
	 * @param materialId
	 * @return
	 */
	List<PmcMaterialUseInfo> getUseInfoList(Long cid,Long materialId);

	/**
	 * 
	 * 
	 * @Comments:  <修改使用地点信息>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年10月30日-下午2:12:23
	 * @param useInfo
	 * @param staffId
	 * @param cid
	 */
	void updateUseAreaInfo(PmcMaterialUseInfo useInfo, Long staffId, Long cid);

	/**
	 * 
	 * 
	 * @Comments:  <新增使用地点信息>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年10月30日-下午2:12:31
	 * @param useInfo
	 * @param staffId
	 * @param cid
	 */
	void addUseAreaInfo(PmcMaterialUseInfo useInfo, Long staffId, Long cid);

	String getUseOrgNames(Long materialId);
}
