package cn.smarthse.modules.health.service.base.material;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.material.PmcCompanyMaterial;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialEhs;
import cn.smarthse.modules.health.entity.base.material.vo.MaterialImportVo;
import cn.smarthse.modules.health.entity.base.material.vo.MatterItemVO;
import cn.smarthse.modules.health.entity.base.material.vo.QueryMatterParam;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 《物料管理Service》
 *
 * @since 2017-06-08 03:04
 */
//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IPmcCompanyMaterialService extends IBaseService<PmcCompanyMaterial> {

    /**
     * 查询物料列表
     */
    PageInfo<MatterItemVO> getMatterItemList(JqGridParam matterParam);

    /**
     * 查询物料列表——职业健康在线
     */
    PageInfo<MatterItemVO> getMatterItemListIsZjProj(JqGridParam matterParam);

    /**
     * 获取所有的原辅料，产品，中间产品的信息。
     *
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author horsy(何世壹) [hsy@smarthse.cn]
     * @since 2019年1月9日-上午11:21:20
     */
    List<MatterItemVO> getAllMatterItemVO();

    /**
     * 查询产品列表
     *
     * @param gparam
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-6-21-下午4:51:36
     */
    PageInfo<MatterItemVO> getProductItemList(JqGridParam gparam);

    /**
     * 删除
     *
     * @param id
     * @param staffId
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-6-22-下午1:16:54
     */
    void del(Long id, Long staffId);

    /**
     * 查询列表
     */
    List<MatterItemVO> getListByCid(QueryMatterParam param);

    /**
     * 查询列表——职业健康在线
     */
    List<MatterItemVO> getListByCidIsZjProj(QueryMatterParam param);

    /**
     * 导入数据生成
     * <p>
     * 原来的企业端第一次进去有初始化，人员，设备，物料之类的都会导入
     *
     * @param ossfile
     * @return
     * @throws Exception
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-8-14-上午9:59:00
     */
    @Deprecated
    ResponseData<List<MaterialImportVo>> importMatter(String ossfile) throws Exception;

    /**
     * 导入数据生成——共享体系、实施版物料辅料
     *
     * @param ossfile
     * @return
     * @throws Exception
     */
    ResponseData<List<MaterialImportVo>> importMatterIsActualizeAndIsSharingSystem(String ossfile) throws Exception;

    /**
     * 导入数据生成——职业健康在线
     *
     * @param ossfile
     * @return
     * @throws Exception
     */
    ResponseData<List<MaterialImportVo>> importMatterIsZjProj(String ossfile, String year) throws Exception;

    /**
     * 导入数据添加
     *
     * @param list
     * @param cid
     * @param loginStaffId
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-8-14-下午2:31:35
     */
    ResponseData<List<MaterialImportVo>> importAdd(List<MaterialImportVo> list, Long cid, Long loginStaffId);

    /**
     * 根据cid查询企业物料数量
     *
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-8-15-上午10:55:42
     */
    Integer getMatterNumByCid(Long cid);


    /**
     * 根据cid查询企业产品数量
     *
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-8-15-上午11:12:48
     */
    Integer getProductNumByCid(Long cid);


    /**
     * 根据cid查询企业物料和产品数量
     *
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-8-15-下午4:59:34
     */
    Integer getNumByCid(Long cid);


    /**
     * 根据cid删除物料信息
     *
     * @param cid
     * @param staffid
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕)
     * @since 2017年8月15日-下午3:40:14
     */
    void deleteMaterialByCid(Long cid, Long staffid);


    /**
     * 查询物料列表
     *
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-9-8-上午9:56:52
     */
    List<MatterItemVO> getMatterList(Long cid);

    /**
     * 按年份查询历史物料列表
     *
     * @param cid
     * @param year
     * @return
     */
    List<MatterItemVO> getMatterList(Long cid, String year);


    /**
     * 查询产品列表
     *
     * @param cid
     * @param type 1.中间产品 2.产品副产品
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author gbx
     * @since 2017-9-8-上午9:57:27
     */
    List<MatterItemVO> getProductList(Long cid, Integer type);

    /**
     * 按年份查询历史产品列表
     *
     * @param cid
     * @param type
     * @param year
     * @return
     */
    List<MatterItemVO> getProductList(Long cid, Integer type, String year);

    /**
     * @param cid
     * @param staffid
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author yanao [ya@smarthse.cn]
     * @since 2018年2月28日-下午2:12:41
     */
    void deleteMaterial(Long cid, Long staffid, String type);

    void deleteMaterialByYear(Long cid, String year, Long staffId);

    /**
     * @param cid
     * @param staffid
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author yanao [ya@smarthse.cn]
     * @since 2018年2月28日-下午2:12:41
     */
    void deleteProduct(Long cid, Long staffid);

    /**
     * 保存物料信息
     *
     * @param material
     * @param loginStaffId
     * @param cid
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年2月28日-下午3:44:12
     */
    PmcCompanyMaterial saveCompanyMaterialInfo(PmcCompanyMaterial material, Long loginStaffId, Long cid);

    PmcCompanyMaterial saveCompanyMaterialInfoIsZjProj(PmcCompanyMaterial material, Long loginStaffId, Long cid);

    /**
     * 保存物料的ehs信息
     *
     * @param materialEhs
     * @param materialId
     * @param loginStaffId
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年2月28日-下午3:53:19
     */
    void updateCompanyMaterialEhsInfo(PmcMaterialEhs materialEhs, Long materialId, Long loginStaffId, Long cid, String[] harmfactorid, Boolean isharm, Boolean ishazard);

    /**
     * 更新危害因素管理关键工作提醒信息
     *
     * @param materialId
     * @param loginStaffId
     * @param cid
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author Horsy(何世壹) [hsy@smarthse.cn]
     * @since 2018年2月28日-下午4:13:41
     */
    void updateHarmFactorManagerTodolistInfo(Long materialId, Long loginStaffId, Long cid);


    /**
     * @param companyMaterialId
     * @param column
     * @Comments: <根据物料id清楚指定字段的值>
     * @author yanao [ya@smarthse.cn]
     * @since 2018年3月6日-上午10:44:17
     */
    void clearImportInfoByIdAndColumn(Long companyMaterialId, String column);

    /**
     * @param cid
     * @param harmType
     * @param meterialType
     * @return
     * @Comments: <获取物料中的高危危害因素>
     * @author yanao [ya@smarthse.cn]
     * @since 2018年8月7日-下午5:15:37
     */
    List<String> getHighHarms(Long cid, Integer harmType, int meterialType);

    MatterItemVO selectMatterItemById(Long cid, Long id);

    /**
     * 获取物料年份数据
     */
    PageInfo<MatterItemVO> getMatterYearData(JqGridParam param);

    /**
     * 为了能每年年初自动生成当年的主要物料信息，物料信息取自上一年年末的数据【定时任务】
     *
     * @param lastDate 数据来源的年
     * @return
     */
    @Deprecated
    void synMatter(Integer lastDate);

    /**
     * 为了能每年年初自动生成当年的主要物料信息，物料信息取自上一年年末的数据【定时任务】
     *
     * @param lastDate 数据来源的年
     * @param newDate  要生成数据的年
     */
    Boolean synMatter2(Integer lastDate, Integer newDate);
}