/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.device;

import java.util.List;
import java.util.Map;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.device.DeviceType;


 /**
 * 
 * 《物料管理Service》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author gbx
 * @since 2017-06-08 03:21
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IDeviceTypeService extends IBaseService<DeviceType>{


	/**
	 * 根据企业id查询设备设施分类
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-6-13-下午1:43:31
	 * @param cid
	 * @return
	 */
	List<DeviceType> getByCid(long cid);
	
	/**
	 * 根据ids删除
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-6-26-上午9:27:29
	 * @param ids
	 * @param staffId
	 */
	void del(String ids,Long staffId);
	
	
	/**
	 * 查询系统设备设施分类
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-8-10-上午10:14:11
	 * @return
	 */
	Map<String, DeviceType> getCompanyDeviceType(Long cid);
	
	/**
	 * 获取职业病防护设施类型列表（职业病防护设施及子节点）
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年11月20日-上午11:08:48
	 * @param cid
	 * @return
	 */
	List<DeviceType> getListForOccDisease(Long cid);
	
	/**
	 * 
	 * 
	 * @Comments:  <根据父id获取所有的子id集合>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年8月14日-上午10:17:41
	 * @param pid
	 * @param cid
	 * @return
	 */
	List<Long> getChildrenTypeIdsByPid(Long pid,Long cid);
}
