/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.device;

import java.util.Date;
import java.util.List;

import cn.smarthse.modules.health.entity.base.device.*;
import cn.smarthse.modules.health.vo.base.DeptDeviceMaintainNum;
import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearWorkService;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;


 /**
 * 
 * 《物料管理Service》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author gbx
 * @since 2017-06-08 03:20
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IDeviceMaintenanceService extends IBaseService<DeviceMaintenance>,IPlanYearWorkService{


	/**
	 * 防护设备维护查询
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-6-26-下午2:17:36
	 * @param param
	 * @return
	 */
	PageInfo<DeviceMaintenance> getItemList(JqGridParam param,Boolean saveState);
	
	
	/**
	 * 根据cid查询列表数据
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-7-6-下午2:00:32
	 * @param cid
	 * @param saveState
	 * @return
	 */
	List<DeviceMaintenance> getList(Long cid,Boolean saveState);
	
	
	/**
	 * 根据cid查询防护设施维护已满一年的数量
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-8-28-下午1:14:53
	 * @param cid
	 * @return
	 */
	DeviceMaintenanceWorkItemVo DeviceMaintenanceWorkItem(Long cid);
	
	/**
	 * 
	 * 
	 * @Comments:  根据年度统计维护数量
	 * @author gbx
	 * @since 2017-9-5-上午9:15:48
	 * @param cid
	 * @param year
	 * @return
	 */
	BaseSummaryVO getSummaryData(Long cid, String year);
	
	/**
	 * 
	 * 
	 * @Comments:  <防护设施维护查询>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年4月17日-下午4:18:57
	 * @param param
	 * @param gparam
	 * @return
	 */
	PageInfo<DeviceMaintenance> getMaintenanceList(JqGridParam gparam,DeviceMaintenanceVo param);


	 /**
	  * 本月待维护防护设备  denglibin v2.9
	  * @param jqGridParam
	  * @param deviceName
	  * @param useAreaId
	  * @return
	  */
	PageInfo<NoMaintainDeviceVo> getNoMaintainDeviceList(JqGridParam jqGridParam, String deviceName, Long useAreaId, Long cid);

	 /**
	  * 本月待维护防护设备  denglibin v2.9
	  * @param jqGridParam
	  * @param deviceName
	  * @param useAreaId
	  * @return
	  */
	PageInfo<NoMaintainDeviceVo> getMaintainDeviceList(JqGridParam jqGridParam, String deviceName, Long useAreaId, Long cid,Byte ifIgnore);


	 /**
	  * 本月待维护防护设备-忽略  denglibin v2.9
	  * @param deviceId
	  */
	void ignoreDevice(Long deviceId,Long loginUserId);

	 /**
	  * 本月待维护防护设备-批量忽略
	  * @param deviceIds
	  * @param loginStaffId
	  */
	 void ignoreDevices(List<Long> deviceIds, Long loginStaffId);

	 /**
	  * 本月待维护防护设备-恢复忽略  yangzp
	  * @param id
	  */
	void recoverDevice(Long id);

	 /**
	  *按部门统计防护设备维护数 v2.9 denglibin
	  * @param deptIds 部门id 可为 null 表示 统计所有部门
	  * @param startDate 日期 开始月份
	  * @param endDate 日期 结束月份
	  * @return
	  */
	PageInfo<DeptDeviceMaintainNum> countDeviceMaintainByDept(int pageNum, int pageSize,
															  List<Long> deptIds, Date startDate, Date endDate, Long cid);


	 /**
	  * 统计设备的维护次数
	  * @param pageNum
	  * @param pageSize
	  * @param deptId 部门id 使用车间
	  * @param typeId 设备类型id
	  * @param deviceName 设备名称
	  * @param deviceNo 编号
	  * @param deviceModel 型号
	  * @param managerId 负责人id
	  * @param startDate 维护时间 开始
	  * @param endDate 维护时间 结束
	  * @param cid 企业id
	  * @return
	  */
	PageInfo<DeviceMaintainNum> countDeviceMaintainNum(int pageNum, int pageSize,
													   Long deptId,  Long typeId, String deviceName,
													   String deviceNo,  String deviceModel, Long managerId,
													    Date startDate, Date endDate,  Long cid);

	 PageInfo<DeviceMaintenance> getItemList(JqGridParam param,Boolean saveState,Integer mainteYear);


 }
