/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.device;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.device.DeviceListView;


 /**
 * 
 * 《物料管理Service》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author gbx
 * @since 2017-06-27 04:14
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IDeviceListViewService extends IBaseService<DeviceListView>{


	/**
	 * 设备设施查询
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-6-26-下午2:17:36
	 * @param param
	 * @return
	 */
	PageInfo<DeviceListView> getDeviceInfoItemList(JqGridParam param);

	
	/**
	 * 获取“非指定设备类型”的其他设备的列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年12月13日-上午9:10:54
	 * @param pageNum 页码
	 * @param pateSize 每页条数
	 * @param cid 企业ID
	 * @param notTypeId 排除的设备类型ID
	 * @return
	 */
	PageInfo<DeviceListView> getDeviceInfoItemListNotType(JqGridParam param ,Long notTypeId);
	
	
	/**
	 * 根据cid查询列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-6-29-下午3:34:54
	 * @param cid
	 * @return
	 */
	List<DeviceListView> getListByCid(Long cid);

	 /**
	  * 一般生产设备查询
	  * @param cid
	  * @return
	  */
	List<DeviceListView> getGeneralDeviceList(Long cid);
	 /**
	  * 防护设备查询
	  * @param cid
	  * @return
	  */
	 List<DeviceListView> getProtectionDeviceList(Long cid);
	/**
	 * 防护设施查询
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-6-26-下午2:17:36
	 * @param param
	 * @return
	 */
	PageInfo<DeviceListView> getDeviceProtectionItemList(JqGridParam param);
	
	
	/**
	 * 根据cid查询设备设施列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-5-下午2:50:06
	 * @param cid
	 * @return
	 */
	List<DeviceListView> getDeviceInfoList(Long cid);
	
	
	/**
	 * 根据cid查询防护设备列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-6-上午8:48:05
	 * @param cid
	 * @return
	 */
	List<DeviceListView> getDeviceList(Long cid,String year);

	/**
	 * @Comments:  <档案接口简单调整>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2022/4/11-10:07
	 * @param cid
	 * @param year
	 * @return java.util.List<cn.smarthse.modules.health.entity.base.device.DeviceListView>
	*/
	List<DeviceListView> selectDeviceListByYear(Long cid, Integer year);

	 /**
	  * 根据cid查询历史防护设备列表
	  * @param cid
	  * @param year
	  * @return
	  */
	List<DeviceListView> getHistoryDeviceList(Long cid,String year);

	
	
	/**
	 * 根据cid查询可能产生职业病危害因素的设备设施列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-6-上午8:48:05
	 * @param cid
	 * @return
	 */
	List<DeviceListView> getDeviceByIsHarmList(Long cid,String year);

	 /**
	  * 根据cid查询可能产生职业病危害因素的历史设备设施列表
	  * @param cid
	  * @param year
	  * @return
	  */
    List<DeviceListView> getHistoryDeviceByIsHarmList(Long cid,String year);
	
	
	/**
	 * 根据使用岗位id查询防护设备
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-9-11-下午1:54:17
	 * @param cid
	 * @param workId
	 * @return
	 */
	List<DeviceListView> getDeviceByWorkId(Long cid,Long workId);

	/**
	 * 
	 * 
	 * @Comments:  <设备设施信息列表（08-001）中有类别为typePid及子类的设备>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年8月2日-下午5:43:07
	 * @param cid
	 * @param typePid
	 * @return
	 */
	int getDeviceNumByTypePid(Long cid, Long typePid);
	 /**
	  * 设备设施年份数据
	  * @param param
	  * @return
	  */
	 PageInfo<DeviceListView> getDeviceYearData(JqGridParam param);
 }
