/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.base.device;

import java.util.List;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.device.DeviceInfo;


 /**
 * 
 * 《物料管理Service》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author gbx
 * @since 2017-06-08 03:20
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IDeviceInfoService extends IBaseService<DeviceInfo>{


	/**
	 * 设备设施导入多sheet
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-8-10-上午9:40:32
	 * @param ossfile 导入文件
	 * @param cid 企业id
	 * @param loginStaffId 员工id
	 * @return
	 */
	List<ResponseData<Object>> getDeviceInfoFromExcel2(String ossfile, Long cid, Long loginStaffId);
	 /**
	  * 设备设施导入,当ResponseData.state是success的时候，Object是list<DeviceInfo>；否则，Object是list<String>,保存的错误信息
	  *
	  * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	  * @author gbx
	  * @since 2017-8-10-上午9:40:32
	  * @param ossfile 导入文件
	  * @param cid 企业id
	  * @param loginStaffId 员工id
	  * @return
	  */
	ResponseData<Object> getDeviceInfoFromExcel(String ossfile, Long cid, Long loginStaffId);
	/**
	 * 导入数据添加
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-8-10-下午1:53:51
	 * @param list
	 * @param cid
	 * @param loginStaffId
	 * @return
	 */
	ResponseData<List<DeviceInfo>> adds(List<DeviceInfo> list, Long cid, Long loginStaffId);
	
	
	/**
	 * 查询企业设备设施数量
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2017-8-10-下午4:11:01
	 * @param cid
	 * @return
	 */
	Integer getDeviceListNum(Long cid);

	
	/**
	 * 根据cid删除所有设备信息，逻辑删除
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年8月15日-下午3:37:08
	 * @param cid
	 * @param staffid
	 */
	void deleteDeviceByCid(Long cid, Long staffid);
	
	/**
	 * 获取类别为职业病防护设施的设备列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年11月20日-上午11:03:03
	 * @param cid
	 * @return
	 */
	List<DeviceInfo> getDeviceListOccDisease(Long cid);
	
	/**
	 * 批量添加设备设施
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年11月24日-下午1:45:00
	 * @param deviceIds 设备设施id列表。
	 * @param deviceType 设备设施类型（需要添加到那个类型下）
	 * @return
	 */
	Integer addDeviceBatch(String deviceIds,Long deviceType,Long loginStaffId);
	
	/**
	 * 批量添加危害因素的信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author Horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2017年11月24日-下午5:16:24
	 * @param deviceIds 设备id字符串，以逗号分隔
	 * @param harmFactors 危害因素ID字符串，以逗号分隔
	 * @param loginStaffId 
	 * @param cid
	 * @return
	 */
	Integer addDeviceHarmFactor(String deviceIds,String harmFactors,Long loginStaffId,Long cid);


	void saveInfo(DeviceInfo device, Long staffId,Long cid);
}
