package cn.smarthse.modules.health.service.base.contact;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.contact.MyContact;
import cn.smarthse.modules.health.entity.base.contact.MyContactGroup;
import cn.smarthse.modules.health.vo.base.contact.ContactVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @Title: ${NAME}
 * @Project:  ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 36
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2019/10/16-10:36
 */
public interface IMyContactService extends IBaseService<MyContact> {

    /**
     * 添加联系人
     * @param staffIds
     * @param groupId
     * @param loginStaffId
     * @param orgId
     * @param cid
     */
    public void addContacts(String staffIds, Long groupId, Long loginStaffId, Long orgId, long cid);

    /**
     * 删除选中的联系人
     * @param ids
     * @param loginStaffId
     */
    public void deleteSel(String ids, Long loginStaffId);


    public List<ContactVo> listContactVo(Long groupId,String searchKey, Long loginStaffId);


    public PageInfo<ContactVo> pageContactVo(JqGridParam gparam,Long groupId, String searchKey, Long loginStaffId);

	/**
	 * 
	 * @Comments:  <根据组id获取联系人>
	 * @author BinXu(徐斌) [784514607@qq.com]
	 * @since 2020年5月27日-下午2:26:17
	 * @param groupId
	 * @param loginStaffId
	 * @return
	 */
	List<ContactVo> listContactVoByGroupId(Long groupId, Long loginStaffId);
}
